/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xbean.spring.context.v2.XBeanV2Helper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }

    @Override
    protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }

    @Override
    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        String namespaceUri = root.getNamespaceURI();
        if (!DomUtils.nodeNameEquals(root, "beans") && !delegate.isDefaultNamespace(namespaceUri)) {
            try {
                try {
                    Method m = BeanDefinitionParserDelegate.class.getMethod("parseCustomElement", Element.class);
                    m.invoke((Object)delegate, root);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method m = BeanDefinitionParserDelegate.class.getMethod("parseCustomElement", Element.class, Boolean.TYPE);
                        m.invoke((Object)delegate, root, Boolean.FALSE);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        } else if (DomUtils.nodeNameEquals(root, "beans")) {
            NodeList nl = root.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node node = nl.item(i2);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                String childNamespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(childNamespaceUri)) {
                    this.parseDefaultElement(ele, delegate);
                    continue;
                }
                delegate.parseCustomElement(ele);
            }
        } else {
            super.parseBeanDefinitions(root, delegate);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        if (DomUtils.nodeNameEquals(ele, "import")) {
            this.importBeanDefinitionResource(ele);
        } else if (DomUtils.nodeNameEquals(ele, "alias")) {
            this.processAliasRegistration(ele);
        } else if (DomUtils.nodeNameEquals(ele, "bean")) {
            this.processBeanDefinition(ele, delegate);
        }
    }

    @Override
    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute("resource");
        if (!StringUtils.hasText(location)) {
            this.getReaderContext().error("Resource location must not be empty", ele);
            return;
        }
        if (ResourcePatternUtils.isUrl(location = SystemPropertyUtils.resolvePlaceholders(location))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", ele, null, ex);
            }
        }
        this.getReaderContext().fireImportProcessed(location, this.extractSource(ele));
    }

    @Override
    protected void processAliasRegistration(Element ele) {
        String name = ele.getAttribute("name");
        String alias = ele.getAttribute("alias");
        boolean valid = true;
        if (!StringUtils.hasText(name)) {
            this.getReaderContext().error("Name must not be empty", ele);
            valid = false;
        }
        if (!StringUtils.hasText(alias)) {
            this.getReaderContext().error("Alias must not be empty", ele);
            valid = false;
        }
        if (valid) {
            try {
                this.getReaderContext().getRegistry().registerAlias(name, alias);
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error(ex.getMessage(), ele);
            }
            this.getReaderContext().fireAliasRegistered(name, alias, this.extractSource(ele));
        }
    }

    @Override
    protected void processBeanDefinition(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(ele);
        if (bdHolder != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getRegistry());
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }
}

