/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternHelper {
    private PatternHelper() {
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equalsIgnoreCase(pattern)) {
            return true;
        }
        if (PatternHelper.matchWildcard(name, pattern)) {
            return true;
        }
        return PatternHelper.matchRegex(name, pattern);
    }

    public static boolean matchPatterns(String name, String[] patterns) {
        for (String pattern : patterns) {
            if (!PatternHelper.matchPattern(name, pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchWildcard(String name, String pattern) {
        if (pattern.endsWith("*")) {
            String text = pattern.substring(0, pattern.length() - 1);
            return name.toLowerCase(Locale.ENGLISH).startsWith(text.toLowerCase(Locale.ENGLISH));
        }
        return false;
    }

    public static boolean matchRegex(String name, String pattern) {
        try {
            Pattern compiled = Pattern.compile(pattern, 2);
            Matcher matcher = compiled.matcher(name);
            return matcher.matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static boolean isExcludePatternMatch(String key, String ... excludePatterns) {
        for (String pattern : excludePatterns) {
            if (!PatternHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> matchingSet(Map<String, Object> map, String pattern, String[] excludePatterns) {
        HashSet<String> toBeRemoved = null;
        for (String key : map.keySet()) {
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            if (toBeRemoved == null) {
                toBeRemoved = new HashSet<String>();
            }
            toBeRemoved.add(key);
        }
        return toBeRemoved;
    }
}

