/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.NameDefinition;
import org.jibx.runtime.JiBXException;

public class PrecompiledBinding
implements IComponent,
ITypeBinding {
    private static final String MARSHALLING_CONTEXT = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHALLING_CONTEXT = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String MARSHALLING_CONTEXT_SIG = "Lorg/jibx/runtime/impl/MarshallingContext;";
    private static final String UNMARSHALLING_CONTEXT_SIG = "Lorg/jibx/runtime/impl/UnmarshallingContext;";
    private static final String PRESENCE_TEST_SIG = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)Z";
    private static final String PUSH_NAMESPACES_METHOD = "org.jibx.runtime.IMarshallingContext.pushNamespaces";
    private static final String PUSH_NAMESPACES_SIG = "(Ljava/lang/String;)V";
    private static final String POP_NAMESPACES_METHOD = "org.jibx.runtime.IMarshallingContext.popNamespaces";
    private static final String POP_NAMESPACES_SIG = "()V";
    private final ClassFile m_class;
    private final String m_newInstanceName;
    private final String m_completeName;
    private final String m_prepareName;
    private final String m_attributePresenceName;
    private final String m_contentPresenceName;
    private final String m_unmarshalAttributeName;
    private final String m_unmarshalContentName;
    private final String m_marshalAttributeName;
    private final String m_marshalContentName;
    private final String m_unmarshalSignature;
    private final String m_completeSignature;
    private final String m_marshalSignature;
    private final String m_factoryName;

    public PrecompiledBinding(int index, String[][] abmaps, boolean xlated, String factname) throws JiBXException {
        this.m_class = ClassCache.requireClassFile(abmaps[1][index]);
        this.m_newInstanceName = abmaps[2][index];
        this.m_completeName = abmaps[3][index];
        this.m_prepareName = abmaps[4][index];
        this.m_attributePresenceName = abmaps[5][index];
        this.m_contentPresenceName = abmaps[8][index];
        this.m_unmarshalAttributeName = abmaps[6][index];
        this.m_unmarshalContentName = abmaps[9][index];
        this.m_marshalAttributeName = abmaps[7][index];
        this.m_marshalContentName = abmaps[10][index];
        String classig = this.m_class.getSignature();
        String basesig = "(" + classig + UNMARSHALLING_CONTEXT_SIG + ")";
        this.m_unmarshalSignature = basesig + classig;
        this.m_completeSignature = basesig + "V";
        this.m_marshalSignature = "(" + classig + MARSHALLING_CONTEXT_SIG + ")V";
        this.m_factoryName = xlated ? factname : null;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalAttributeName != null) {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_unmarshalAttributeName, this.m_unmarshalSignature);
        }
    }

    @Override
    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalAttributeName != null) {
            if (this.m_factoryName != null) {
                mb.loadContext();
                mb.appendLoadConstant(this.m_factoryName);
                mb.appendCallInterface(PUSH_NAMESPACES_METHOD, PUSH_NAMESPACES_SIG);
            }
            mb.loadContext(MARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_marshalAttributeName, this.m_marshalSignature);
            if (this.m_factoryName != null) {
                mb.loadContext();
                mb.appendCallInterface(POP_NAMESPACES_METHOD, POP_NAMESPACES_SIG);
            }
        }
    }

    @Override
    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalContentName != null) {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_unmarshalContentName, this.m_unmarshalSignature);
        }
    }

    @Override
    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalContentName != null) {
            if (this.m_factoryName != null) {
                mb.loadContext();
                mb.appendLoadConstant(this.m_factoryName);
                mb.appendCallInterface(PUSH_NAMESPACES_METHOD, PUSH_NAMESPACES_SIG);
            }
            mb.loadContext(MARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_marshalContentName, this.m_marshalSignature);
            if (this.m_factoryName != null) {
                mb.loadContext();
                mb.appendCallInterface(POP_NAMESPACES_METHOD, POP_NAMESPACES_SIG);
            }
        }
    }

    @Override
    public void genNewInstance(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_newInstanceName != null) {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_newInstanceName, this.m_unmarshalSignature);
        }
    }

    @Override
    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributePresenceName != null) {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_attributePresenceName, PRESENCE_TEST_SIG);
        }
    }

    @Override
    public void genContentPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contentPresenceName != null) {
            mb.loadContext(UNMARSHALLING_CONTEXT);
            mb.appendCallStatic(this.m_contentPresenceName, PRESENCE_TEST_SIG);
        }
    }

    @Override
    public String getType() {
        return this.m_class.getName();
    }

    @Override
    public boolean hasId() {
        return false;
    }

    @Override
    public void genLoadId(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error: id not usable with abstract precompiled binding");
    }

    @Override
    public void setLinkages() {
    }

    @Override
    public NameDefinition getWrapperName() {
        return null;
    }

    @Override
    public boolean hasAttribute() {
        return this.m_unmarshalAttributeName != null || this.m_marshalAttributeName != null;
    }

    @Override
    public boolean hasContent() {
        return this.m_unmarshalContentName != null || this.m_marshalContentName != null;
    }

    @Override
    public String getAttributeMarshalMethod() throws JiBXException {
        return this.m_marshalAttributeName;
    }

    @Override
    public String getAttributePresentTestMethod() throws JiBXException {
        return this.m_attributePresenceName;
    }

    @Override
    public String getAttributeUnmarshalMethod() throws JiBXException {
        return this.m_unmarshalAttributeName;
    }

    @Override
    public String getCompleteMethod() throws JiBXException {
        return this.m_completeName;
    }

    @Override
    public String getContentMarshalMethod() throws JiBXException {
        return this.m_marshalContentName;
    }

    @Override
    public String getContentPresentTestMethod() throws JiBXException {
        return this.m_contentPresenceName;
    }

    @Override
    public String getContentUnmarshalMethod() throws JiBXException {
        return this.m_unmarshalContentName;
    }

    @Override
    public String getCreateMethod() throws JiBXException {
        return this.m_newInstanceName;
    }

    @Override
    public String getPrepareMethod() throws JiBXException {
        return this.m_prepareName;
    }

    @Override
    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.println("precompiled binding for " + this.m_class.getName());
    }
}

