/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTScalar;

class ToCacheKeyTraversalHandler
implements TraversalHandler {
    private ValueObjectTypeRegistry registry;
    private StringBuilder out;

    ToCacheKeyTraversalHandler(ValueObjectTypeRegistry registry, StringBuilder out) {
        this.registry = registry;
        this.out = out;
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        this.out.append(',');
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        if (node.getType() == 45) {
            this.out.append(((ASTFunctionCall)node).getFunctionName()).append('(');
        } else {
            this.out.append(node.getType()).append('(');
        }
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        this.out.append(')');
    }

    @Override
    public void objectNode(Object leaf, Expression parentNode) {
        ValueObjectType<?, ?> valueObjectType;
        if (leaf == null) {
            this.out.append("null");
            return;
        }
        if (leaf instanceof ASTScalar) {
            leaf = ((ASTScalar)leaf).getValue();
        } else if (leaf instanceof Object[]) {
            for (Object value : (Object[])leaf) {
                this.objectNode(value, parentNode);
                this.out.append(',');
            }
            return;
        }
        if (leaf instanceof Persistent) {
            ObjectId id = ((Persistent)leaf).getObjectId();
            Object encode = id != null ? id : leaf;
            this.out.append(encode);
        } else if (leaf instanceof Enum) {
            Enum e = (Enum)leaf;
            this.out.append("e:").append(leaf.getClass().getName()).append(':').append(e.ordinal());
        } else if (this.registry == null || (valueObjectType = this.registry.getValueType(leaf.getClass())) == null) {
            this.out.append(leaf);
        } else {
            this.out.append(valueObjectType.toCacheKey(leaf));
        }
    }
}

