/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class LongConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(LongConverterTestCase.class);
    }

    public LongConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Long.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new LongConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new LongConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Long.valueOf("-12");
        this.numbers[1] = Long.valueOf("13");
        this.numbers[2] = Long.valueOf("-22");
        this.numbers[3] = Long.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Long.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Long.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Long[] expected = new Long[]{Long.MIN_VALUE, -17L, -1L, 0L, 1L, 17L, Long.MAX_VALUE, 7L, 8L, 9L, 10L, 11L, 12L};
        for (int i = 0; i < expected.length; ++i) {
            LongConverterTestCase.assertEquals((String)(message[i] + " to Long"), (Object)expected[i], (Object)this.converter.convert(Long.class, input[i]));
            LongConverterTestCase.assertEquals((String)(message[i] + " to long"), (Object)expected[i], (Object)this.converter.convert(Long.TYPE, input[i]));
            LongConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

