/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.zip.TestEntityResolver;
import org.apache.commons.vfs2.provider.zip.TestErrorHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ParseXmlInZipTest {
    private Locale defaultLocale;

    @BeforeEach
    public void changeDefaultLocale() {
        this.defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
    }

    private Path createTempFile() throws IOException {
        Path zipFile = Paths.get("src/test/resources/test-data/read-xml-tests.zip", new String[0]);
        Path newZipFile = Files.createTempFile(this.getClass().getSimpleName(), ".zip", new FileAttribute[0]);
        newZipFile.toFile().deleteOnExit();
        Files.copy(zipFile, newZipFile, StandardCopyOption.REPLACE_EXISTING);
        return newZipFile;
    }

    private DocumentBuilder newDocumentBuilder(FileObject containerFile, FileObject sourceFile, String pathToXsdInZip) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean validate = pathToXsdInZip != null;
        documentBuilderFactory.setValidating(validate);
        documentBuilderFactory.setNamespaceAware(true);
        if (validate) {
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            FileObject schema = containerFile.resolveFile(pathToXsdInZip);
            if (!schema.exists()) {
                schema.close();
                throw new FileNotFoundException(schema.toString());
            }
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schema.getContent().getInputStream());
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new TestEntityResolver(containerFile, sourceFile));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot read Java Connector configuration: " + e, e);
        }
        documentBuilder.setErrorHandler(new TestErrorHandler(containerFile + " - " + sourceFile));
        return documentBuilder;
    }

    @AfterEach
    public void resetDefaultLocale() {
        Locale.setDefault(this.defaultLocale);
    }

    @Test
    public void testParseXmlInZip() throws IOException, SAXException {
        Path newZipFile = this.createTempFile();
        String xmlFilePath = "zip:file:" + newZipFile.toAbsolutePath() + "!/read-xml-tests/file1.xml";
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile(xmlFilePath);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            Document document = this.newDocumentBuilder(zipFileObject, zipFileObject, null).parse(inputStream);
            Assertions.assertNotNull((Object)document);
        }
    }

    @Test
    public void testResolveAndParseBiggerXmlInZip() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/file3-bigger.xml", null);
    }

    @Test
    public void testResolveAndParseInvalidXml() throws IOException, SAXException {
        try {
            this.testResolveAndParseXmlInZip("read-xml-tests/name-invalid.xml", "/read-xml-tests/name.xsd");
        }
        catch (SAXException e) {
            Pattern p = Pattern.compile("Invalid content was found starting with element.+FOO");
            Assertions.assertTrue((boolean)p.matcher(e.toString()).find());
        }
    }

    @Test
    public void testResolveAndParseNotWellFormedXml() throws IOException {
        try {
            this.testResolveAndParseXmlInZip("read-xml-tests/name-not-well-formed.xml", "/read-xml-tests/name.xsd");
        }
        catch (SAXException e) {
            Assertions.assertTrue((boolean)e.toString().contains("XML document structures must start and end within the same entity."));
        }
    }

    @Test
    public void testResolveAndParseXmlInZip() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/file1.xml", null);
    }

    private void testResolveAndParseXmlInZip(String xmlPathInZip, String xsdPathInZip) throws IOException, FileSystemException, SAXException {
        Path newZipFile = this.createTempFile();
        String zipFilePath = "zip:file:" + newZipFile.toAbsolutePath();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile(zipFilePath);
             FileObject xmlFileObject = zipFileObject.resolveFile(xmlPathInZip);
             InputStream inputStream = xmlFileObject.getContent().getInputStream();){
            Document document = this.newDocumentBuilder(zipFileObject, xmlFileObject, xsdPathInZip).parse(inputStream);
            Assertions.assertNotNull((Object)document);
        }
    }

    @Test
    public void testResolveAndParseXmlInZipWithOneXmlSchema() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/name-with-xsd-ref.xml", "/read-xml-tests/name.xsd");
    }

    @Test
    public void testResolveAndParseXmlInZipWithTwoXmlSchema() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/person.xml", "/read-xml-tests/person.xsd");
    }
}

