/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.time.Duration;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;

@Deprecated
public class HttpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static final String KEY_FOLLOW_REDIRECT = "followRedirect";
    protected static final String KEY_USER_AGENT = "userAgent";
    private static final HttpFileSystemConfigBuilder BUILDER = new HttpFileSystemConfigBuilder();
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ZERO;
    private static final Duration DEFAULT_SO_TIMEOUT = Duration.ZERO;
    private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
    private static final String DEFAULT_USER_AGENT = "Jakarta-Commons-VFS";
    private static final String KEY_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private HttpFileSystemConfigBuilder() {
        super("http.");
    }

    protected HttpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HttpFileSystem.class;
    }

    @Deprecated
    public int getConnectionTimeout(FileSystemOptions opts) {
        return this.getDurationInteger(opts, "http.connection.timeout", DEFAULT_CONNECTION_TIMEOUT);
    }

    public Duration getConnectionTimeoutDuration(FileSystemOptions opts) {
        return this.getDuration(opts, "http.connection.timeout", DEFAULT_CONNECTION_TIMEOUT);
    }

    public Cookie[] getCookies(FileSystemOptions opts) {
        return (Cookie[])this.getParam(opts, "cookies");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_FOLLOW_REDIRECT, true);
    }

    public int getMaxConnectionsPerHost(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-per-host", 5);
    }

    public int getMaxTotalConnections(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-total", 50);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions opts) {
        return (UserAuthenticator)this.getParam(opts, "proxyAuthenticator");
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    @Deprecated
    public int getSoTimeout(FileSystemOptions opts) {
        return this.getDurationInteger(opts, "http.socket.timeout", DEFAULT_SO_TIMEOUT);
    }

    public Duration getSoTimeoutDuration(FileSystemOptions opts) {
        return this.getDuration(opts, "http.socket.timeout", DEFAULT_SO_TIMEOUT);
    }

    public String getUrlCharset(FileSystemOptions opts) {
        return this.getString(opts, "urlCharset");
    }

    public String getUserAgent(FileSystemOptions opts) {
        String userAgent = (String)this.getParam(opts, KEY_USER_AGENT);
        return userAgent != null ? userAgent : DEFAULT_USER_AGENT;
    }

    public boolean isPreemptiveAuth(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setConnectionTimeout(FileSystemOptions opts, Duration timeout) {
        this.setParam(opts, "http.connection.timeout", timeout);
    }

    @Deprecated
    public void setConnectionTimeout(FileSystemOptions opts, int timeout) {
        this.setConnectionTimeout(opts, Duration.ofMillis(timeout));
    }

    public void setCookies(FileSystemOptions opts, Cookie[] cookies) {
        this.setParam(opts, "cookies", cookies);
    }

    public void setFollowRedirect(FileSystemOptions opts, boolean redirect) {
        this.setParam(opts, KEY_FOLLOW_REDIRECT, redirect);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions opts, int maxHostConnections) {
        this.setParam(opts, "http.connection-manager.max-per-host", maxHostConnections);
    }

    public void setMaxTotalConnections(FileSystemOptions opts, int maxTotalConnections) {
        this.setParam(opts, "http.connection-manager.max-total", maxTotalConnections);
    }

    public void setPreemptiveAuth(FileSystemOptions opts, boolean preemptiveAuth) {
        this.setParam(opts, KEY_PREEMPTIVE_AUTHENTICATION, (Object)preemptiveAuth);
    }

    public void setProxyAuthenticator(FileSystemOptions opts, UserAuthenticator authenticator) {
        this.setParam(opts, "proxyAuthenticator", authenticator);
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", proxyPort);
    }

    public void setSoTimeout(FileSystemOptions opts, Duration timeout) {
        this.setParam(opts, "http.socket.timeout", timeout);
    }

    @Deprecated
    public void setSoTimeout(FileSystemOptions opts, int timeout) {
        this.setSoTimeout(opts, Duration.ofMillis(timeout));
    }

    public void setUrlCharset(FileSystemOptions opts, String charset) {
        this.setParam(opts, "urlCharset", charset);
    }

    public void setUserAgent(FileSystemOptions opts, String userAgent) {
        this.setParam(opts, KEY_USER_AGENT, userAgent);
    }
}

