/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.FilterEvent;

public class IoEvent
implements Runnable {
    private final IoEventType type;
    private final IoSession session;
    private final Object parameter;

    public IoEvent(IoEventType type, IoSession session, Object parameter) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        this.type = type;
        this.session = session;
        this.parameter = parameter;
    }

    public IoEventType getType() {
        return this.type;
    }

    public IoSession getSession() {
        return this.session;
    }

    public Object getParameter() {
        return this.parameter;
    }

    @Override
    public void run() {
        this.fire();
    }

    public void fire() {
        switch (this.type) {
            case CLOSE: {
                this.session.getFilterChain().fireFilterClose();
                break;
            }
            case EVENT: {
                this.session.getFilterChain().fireEvent((FilterEvent)this.getParameter());
                break;
            }
            case EXCEPTION_CAUGHT: {
                this.session.getFilterChain().fireExceptionCaught((Throwable)this.getParameter());
                break;
            }
            case INPUT_CLOSED: {
                this.session.getFilterChain().fireInputClosed();
                break;
            }
            case MESSAGE_RECEIVED: {
                this.session.getFilterChain().fireMessageReceived(this.getParameter());
                break;
            }
            case MESSAGE_SENT: {
                this.session.getFilterChain().fireMessageSent((WriteRequest)this.getParameter());
                break;
            }
            case SESSION_CLOSED: {
                this.session.getFilterChain().fireSessionClosed();
                break;
            }
            case SESSION_CREATED: {
                this.session.getFilterChain().fireSessionCreated();
                break;
            }
            case SESSION_IDLE: {
                this.session.getFilterChain().fireSessionIdle((IdleStatus)this.getParameter());
                break;
            }
            case SESSION_OPENED: {
                this.session.getFilterChain().fireSessionOpened();
                break;
            }
            case WRITE: {
                this.session.getFilterChain().fireFilterWrite((WriteRequest)this.getParameter());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)this.getType()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.session);
        sb.append(']');
        sb.append(this.type.name());
        if (this.parameter != null) {
            sb.append(':');
            sb.append(this.parameter);
        }
        return sb.toString();
    }
}

