/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.ext.logging.Logging;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;

public class LoggingFactoryBeanListener
implements FactoryBeanListener {
    public void handleEvent(FactoryBeanListener.Event ev, AbstractServiceFactoryBean factory, Object ... args) {
        switch (ev) {
            case ENDPOINT_SELECTED: {
                Class cls = (Class)args[2];
                Endpoint ep = (Endpoint)args[1];
                Bus bus = factory.getBus();
                if (cls == null) {
                    return;
                }
                this.addLoggingSupport(ep, bus, cls.getAnnotation(Logging.class));
                break;
            }
            case SERVER_CREATED: {
                Class cls = (Class)args[2];
                if (cls == null) {
                    return;
                }
                Server server = (Server)args[0];
                Bus bus = factory.getBus();
                this.addLoggingSupport(server.getEndpoint(), bus, cls.getAnnotation(Logging.class));
                break;
            }
        }
    }

    private void addLoggingSupport(Endpoint endpoint, Bus bus, Logging annotation) {
        if (annotation != null) {
            LoggingFeature lf = new LoggingFeature();
            lf.setInMemThreshold(annotation.inMemThresHold());
            lf.setPrettyLogging(annotation.pretty());
            lf.setLimit(annotation.limit());
            lf.setLogBinary(annotation.logBinary());
            lf.setLogMultipart(annotation.logMultipart());
            lf.initialize((InterceptorProvider)endpoint, bus);
        }
    }
}

