/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring;

import java.util.List;
import javax.servlet.ServletContext;
import org.apache.cxf.fediz.core.config.FedizConfigurator;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

public class FederationConfigImpl
implements FederationConfig,
ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationConfigImpl.class);
    private Resource configFile;
    private String contextName;
    private String relativePath;
    private ServletContext servletContext;
    private FedizConfigurator configurator = new FedizConfigurator();

    public Resource getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(Resource configFile) {
        this.configFile = configFile;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void init() {
        Assert.notNull((Object)this.configFile, (String)"property 'configFile' mandatory");
        try {
            this.configurator.loadConfig(this.configFile.getFile());
        }
        catch (Exception e) {
            LOG.error("Failed to parse '" + this.configFile.getDescription() + "'", (Throwable)e);
            throw new BeanCreationException("Failed to parse '" + this.configFile.getDescription() + "'", (Throwable)e);
        }
    }

    @Override
    public List<FedizContext> getFedizContextList() {
        return this.configurator.getFedizContextList();
    }

    @Override
    public FedizContext getFedizContext(String context) {
        FedizContext ctx = this.configurator.getFedizContext(context);
        if (ctx == null) {
            LOG.error("Federation context '" + context + "' not found.");
            throw new IllegalStateException("Federation context '" + context + "' not found.");
        }
        this.initializeRelativePath(ctx);
        return ctx;
    }

    private void initializeRelativePath(FedizContext ctx) {
        String jettyHome;
        String catalinaBase;
        if (this.relativePath != null && this.relativePath.length() > 0) {
            ctx.setRelativePath(this.relativePath);
        }
        if (ctx.getRelativePath() == null && (catalinaBase = System.getProperty("catalina.base")) != null && catalinaBase.length() > 0) {
            ctx.setRelativePath(catalinaBase);
        }
        if (ctx.getRelativePath() == null && (jettyHome = System.getProperty("jetty.home")) != null && jettyHome.length() > 0) {
            ctx.setRelativePath(jettyHome);
        }
    }

    @Override
    public FedizContext getFedizContext() {
        if (this.servletContext != null) {
            LOG.debug("Reading federation configuration for context '{}'", (Object)this.servletContext.getContextPath());
            return this.getFedizContext(this.servletContext.getContextPath());
        }
        Assert.notNull((Object)this.contextName, (String)"Property 'contextName' must be configured because ServletContext null");
        return this.getFedizContext(this.contextName);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }
}

