/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class KllMemoryValidateTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFamily() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryFamilyID((WritableMemory)wmem, (int)(Family.KLL.getID() - 1));
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemorySerVer((WritableMemory)wmem, (int)0);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidEmptyAndSingleFormat() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryEmptyFlag((WritableMemory)wmem, (boolean)true);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidUpdatableAndSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemorySerVer((WritableMemory)wmem, (int)2);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)5);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleAndSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemorySerVer((WritableMemory)wmem, (int)1);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidEmptyDoublesAndPreIntsFull() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)5);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleDoubleCompactAndSerVer() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemorySerVer((WritableMemory)wmem, (int)1);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidDoubleUpdatableAndPreInts() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)2);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFloatFullAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)2);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFloatUpdatableFullAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)2);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidDoubleCompactSingleAndPreInts() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        byte[] byteArr = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllPreambleUtil.setMemoryPreInts((WritableMemory)wmem, (int)5);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)wmem, KllSketch.SketchType.DOUBLES_SKETCH);
    }
}

