/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIteratorAPI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchIteratorTest {
    @Test
    public void emptySketch() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)it.getQuantile(), (double)1.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.update(2.0);
        QuantilesDoublesSketchIteratorAPI itr = sketch.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((double)itr.getQuantile(), (double)2.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((double)itr.getQuantile(), (double)1.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.update(2.0);
        DoublesSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((double)itr.getQuantile(), (double)1.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((double)itr.getQuantile(), (double)2.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
            for (int i = 0; i < n; ++i) {
                sketch.update((double)i);
            }
            QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

