/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.ClosestTypeArgumentQualifier;
import io.micronaut.inject.qualifiers.CompositeQualifier;
import io.micronaut.inject.qualifiers.ExactTypeArgumentNameQualifier;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.NameQualifier;
import io.micronaut.inject.qualifiers.NamedAnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.NoneQualifier;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import io.micronaut.inject.qualifiers.RepeatableAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Qualifiers {
    public static <T> Qualifier<T> any() {
        return AnyQualifier.INSTANCE;
    }

    public static <T> Qualifier<T> none() {
        return NoneQualifier.INSTANCE;
    }

    @Nullable
    public static <T> Qualifier<T> forArgument(@NonNull Argument<?> argument) {
        List<String> qualifierTypes;
        AnnotationMetadata annotationMetadata = Objects.requireNonNull(argument, "Argument cannot be null").getAnnotationMetadata();
        boolean hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        List<String> list = qualifierTypes = hasMetadata ? annotationMetadata.getAnnotationNamesByStereotype("javax.inject.Qualifier") : null;
        if (CollectionUtils.isNotEmpty(qualifierTypes)) {
            if (qualifierTypes.size() == 1) {
                return Qualifiers.byAnnotation(annotationMetadata, qualifierTypes.iterator().next());
            }
            Qualifier[] qualifiers = new Qualifier[qualifierTypes.size()];
            int i2 = 0;
            for (String type : qualifierTypes) {
                qualifiers[i2++] = Qualifiers.byAnnotation(annotationMetadata, type);
            }
            return Qualifiers.byQualifiers(qualifiers);
        }
        return null;
    }

    public static <T> Qualifier<T> byQualifiers(Qualifier<T> ... qualifiers) {
        return new CompositeQualifier(qualifiers);
    }

    public static <T> Qualifier<T> byName(String name) {
        return new NameQualifier(null, name);
    }

    public static <T> Qualifier<T> byAnnotation(Annotation annotation) {
        Qualifier<T> qualifier = Qualifiers.findCustomByType(AnnotationMetadata.EMPTY_METADATA, annotation.annotationType());
        if (qualifier != null) {
            return qualifier;
        }
        return new AnnotationQualifier(annotation);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, Class<? extends Annotation> type) {
        Qualifier<T> instance = Qualifiers.findCustomByType(metadata, type);
        if (instance != null) {
            return instance;
        }
        return AnnotationMetadataQualifier.fromType(metadata, type);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, String type) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, type);
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromTypeName(metadata, type);
    }

    public static <T extends Annotation> Qualifier<T> byAnnotation(AnnotationMetadata metadata, AnnotationValue<T> annotationValue) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, annotationValue.getAnnotationName());
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromValue(metadata, annotationValue);
    }

    public static <T> Qualifier<T> byRepeatableAnnotation(AnnotationMetadata metadata, String repeatableType) {
        return new RepeatableAnnotationQualifier(metadata, repeatableType);
    }

    @Internal
    public static <T> Qualifier<T> byAnnotationSimple(AnnotationMetadata metadata, String type) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, type);
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromTypeName(metadata, type);
    }

    public static <T> Qualifier<T> byStereotype(Class<? extends Annotation> stereotype) {
        Qualifier<T> instance = Qualifiers.findCustomByType(AnnotationMetadata.EMPTY_METADATA, stereotype);
        if (instance != null) {
            return instance;
        }
        return new AnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byStereotype(String stereotype) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(AnnotationMetadata.EMPTY_METADATA, stereotype);
        if (qualifier != null) {
            return qualifier;
        }
        return new NamedAnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byTypeArguments(Class ... typeArguments) {
        return new TypeArgumentQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byExactTypeArgumentName(@NonNull String typeName) {
        return new ExactTypeArgumentNameQualifier(typeName);
    }

    public static <T> Qualifier<T> byTypeArgumentsClosest(Class ... typeArguments) {
        return new ClosestTypeArgumentQualifier(typeArguments);
    }

    public static <T> Qualifier<T> byType(Class ... typeArguments) {
        return new TypeAnnotationQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBinding(@NonNull AnnotationMetadata annotationMetadata) {
        return new InterceptorBindingQualifier(annotationMetadata);
    }

    @Deprecated
    @NonNull
    public static <T> Qualifier<T> byInterceptorBinding(@NonNull Collection<String> bindingAnnotationNames) {
        return new InterceptorBindingQualifier(bindingAnnotationNames.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBindingValues(@NonNull Collection<AnnotationValue<?>> binding) {
        return new InterceptorBindingQualifier(binding);
    }

    @Nullable
    private static <T> Qualifier<T> findCustomByType(@NonNull AnnotationMetadata metadata, @NonNull Class<? extends Annotation> type) {
        Optional<String> value;
        if (Any.class == type) {
            return AnyQualifier.INSTANCE;
        }
        if (Primary.class == type) {
            return PrimaryQualifier.INSTANCE;
        }
        if (Type.class == type) {
            Optional<Class> aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType(aClass.get());
            }
        } else if ((Named.class == type || "javax.inject.Named".equals(type.getName())) && (value = metadata.stringValue(type)).isPresent()) {
            return Qualifiers.byName(value.get());
        }
        return null;
    }

    @Nullable
    private static <T> Qualifier<T> findCustomByName(@NonNull AnnotationMetadata metadata, @NonNull String type) {
        if (Type.NAME.equals(type)) {
            Optional<Class> aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType(aClass.get());
            }
        } else {
            String n;
            if (Any.NAME.equals(type)) {
                return AnyQualifier.INSTANCE;
            }
            if (Qualifier.PRIMARY.equals(type)) {
                return PrimaryQualifier.INSTANCE;
            }
            if ((Named.class.getName().equals(type) || "javax.inject.Named".equals(type)) && (n = (String)metadata.stringValue(type).orElse(null)) != null) {
                return Qualifiers.byName(n);
            }
        }
        return null;
    }
}

