/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface AutowiredArguments {
    @Nullable
    default public <T> T get(int index2, Class<T> requiredType) {
        Object value = this.getObject(index2);
        if (!ClassUtils.isAssignableValue(requiredType, value)) {
            throw new IllegalArgumentException("Argument type mismatch: expected '" + ClassUtils.getQualifiedName(requiredType) + "' for value [" + String.valueOf(value) + "]");
        }
        return (T)value;
    }

    @Nullable
    default public <T> T get(int index2) {
        return (T)this.getObject(index2);
    }

    @Nullable
    default public Object getObject(int index2) {
        return this.toArray()[index2];
    }

    public Object[] toArray();

    public static AutowiredArguments of(Object[] arguments) {
        Assert.notNull((Object)arguments, "'arguments' must not be null");
        return () -> arguments;
    }
}

