/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.communication.AbstractTransmission;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;

abstract class TransmissionReceiver
extends AbstractTransmission {
    protected TransmissionReceiver(TransmissionMeta meta, BooleanSupplier stopChecker, IgniteLogger log, int chunkSize) {
        super(meta, stopChecker, log, chunkSize);
    }

    public void receive(ReadableByteChannel ch) throws IOException, InterruptedException {
        while (this.hasNextChunk()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Recevier has been interrupted");
            }
            if (this.stopped()) {
                throw new IgniteException("Receiver has been cancelled. Channel processing has been stopped.");
            }
            this.readChunk(ch);
        }
        assert (this.transferred == this.meta.count()) : "The number of transferred bytes are not as expected [expect=" + this.meta.count() + ", actual=" + this.transferred + "]";
    }

    protected abstract void readChunk(ReadableByteChannel var1) throws IOException;
}

