/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteJoinConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;

public class CorrelatedNestedLoopJoinRule
extends AbstractIgniteJoinConverterRule {
    public static final RelOptRule INSTANCE = new CorrelatedNestedLoopJoinRule(1);
    public static final RelOptRule INSTANCE_BATCHED = new CorrelatedNestedLoopJoinRule(100);
    private final int batchSize;

    public CorrelatedNestedLoopJoinRule(int batchSize) {
        super("CorrelatedNestedLoopJoin", HintDefinition.CNL_JOIN);
        this.batchSize = batchSize;
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalJoin rel) {
        final int leftFieldCnt = rel.getLeft().getRowType().getFieldCount();
        RelOptCluster cluster = rel.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = this.relBuilderFactory.create(rel.getCluster(), null);
        HashSet<CorrelationId> correlationIds = new HashSet<CorrelationId>();
        final ArrayList<RexNode> corrVar = new ArrayList<RexNode>();
        if (corrVar.isEmpty()) {
            for (int i = 0; i < this.batchSize; ++i) {
                CorrelationId correlationId = cluster.createCorrel();
                correlationIds.add(correlationId);
                corrVar.add(rexBuilder.makeCorrel(rel.getLeft().getRowType(), correlationId));
            }
        }
        RexNode condition = (RexNode)rel.getCondition().accept((RexVisitor)new RexShuttle(){

            public RexNode visitInputRef(RexInputRef input) {
                int field = input.getIndex();
                if (field >= leftFieldCnt) {
                    return rexBuilder.makeInputRef(input.getType(), input.getIndex() - leftFieldCnt);
                }
                return rexBuilder.makeFieldAccess((RexNode)corrVar.get(0), field);
            }
        });
        ArrayList<RexNode> conditionList = new ArrayList<RexNode>();
        conditionList.add(condition);
        int i = 1;
        while (i < this.batchSize) {
            final int corrIdx = i++;
            RexNode condition2 = (RexNode)condition.accept((RexVisitor)new RexShuttle(){

                public RexNode visitCorrelVariable(RexCorrelVariable variable) {
                    return (RexNode)corrVar.get(corrIdx);
                }
            });
            conditionList.add(condition2);
        }
        RelTraitSet filterInTraits = rel.getRight().getTraitSet();
        relBuilder.push(rel.getRight().copy(filterInTraits, rel.getRight().getInputs())).filter(new RexNode[]{relBuilder.or(conditionList)});
        RelNode right = relBuilder.build();
        JoinRelType joinType = rel.getJoinType();
        RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet leftInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        CorrelationTrait corrTrait = CorrelationTrait.correlations(correlationIds);
        RelTraitSet rightInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)corrTrait);
        RelNode left = CorrelatedNestedLoopJoinRule.convert((RelNode)rel.getLeft(), (RelTraitSet)leftInTraits);
        right = CorrelatedNestedLoopJoinRule.convert((RelNode)right, (RelTraitSet)rightInTraits);
        return new IgniteCorrelatedNestedLoopJoin(cluster, outTraits, left, right, rel.getCondition(), correlationIds, joinType);
    }

    @Override
    public boolean matchesJoin(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        return CorrelatedNestedLoopJoinRule.supportedJoinType(join.getJoinType());
    }

    private static boolean supportedJoinType(JoinRelType type) {
        return type == JoinRelType.INNER || type == JoinRelType.LEFT;
    }
}

