/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;

public class HashAggregateConverterRule {
    public static final RelOptRule COLOCATED = new ColocatedHashAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new MapReduceHashAggregateConverterRule();

    private HashAggregateConverterRule() {
    }

    private static class MapReduceHashAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        MapReduceHashAggregateConverterRule() {
            super(LogicalAggregate.class, "MapReduceHashAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelNode input = MapReduceHashAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            IgniteMapHashAggregate map = new IgniteMapHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.random()), input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            return new IgniteReduceHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), MapReduceHashAggregateConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), agg.getRowType());
        }
    }

    private static class ColocatedHashAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        ColocatedHashAggregateConverterRule() {
            super(LogicalAggregate.class, "ColocatedHashAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelNode input = ColocatedHashAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            return new IgniteColocatedHashAggregate(cluster, outTrait, input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
    }
}

