/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.cli.call.unit.ListUnitCallInput;
import org.apache.ignite3.rest.client.model.DeploymentStatus;
import picocli.CommandLine;

public class UnitListOptionsMixin {
    @CommandLine.ArgGroup(exclusive=false)
    private UnitVersion unitVersion;
    @CommandLine.Option(names={"--status"}, description={"Filters out deployment unit by status"}, split=",")
    private DeploymentStatus[] statuses;

    public ListUnitCallInput toListUnitCallInput(String url) {
        String unitId = this.unitVersion != null ? this.unitVersion.unitId : null;
        String version = this.unitVersion != null ? this.unitVersion.version : null;
        List<DeploymentStatus> statuses = this.statuses != null ? Arrays.asList(this.statuses) : null;
        return ListUnitCallInput.builder().unitId(unitId).version(version).statuses(statuses).url(url).build();
    }

    private static class UnitVersion {
        @CommandLine.Parameters(description={"Deployment unit id"}, arity="1", defaultValue="_NULL_")
        private String unitId;
        @CommandLine.Option(names={"--version"}, description={"Filters out deployment unit by version (exact match assumed)"})
        private String version;

        private UnitVersion() {
        }
    }
}

