/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.SyncTimeCommand;
import org.apache.ignite3.internal.metastorage.command.SyncTimeCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class SyncTimeCommandDeserializer
implements MessageDeserializer<SyncTimeCommand> {
    private final SyncTimeCommandBuilder msg;

    SyncTimeCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.syncTimeCommand();
    }

    @Override
    public Class<SyncTimeCommand> klass() {
        return SyncTimeCommand.class;
    }

    @Override
    public SyncTimeCommand getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("initiatorTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTerm(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime(tmp);
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SyncTimeCommand.class);
    }
}

