/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.freelist.io;

import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;

public class PagesListNodeIo
extends PageIo {
    public static final int T_PAGE_LIST_NODE = 2;
    public static final IoVersions<PagesListNodeIo> VERSIONS = new IoVersions((PageIo[])new PagesListNodeIo[]{new PagesListNodeIo(1)});
    private static final int PREV_PAGE_ID_OFF = 40;
    private static final int NEXT_PAGE_ID_OFF = 48;
    private static final int CNT_OFF = 56;
    private static final int PAGE_IDS_OFF = 58;

    protected PagesListNodeIo(int ver) {
        super(2, ver, (byte)2);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setEmpty(pageAddr);
        this.setPreviousId(pageAddr, 0L);
        this.setNextId(pageAddr, 0L);
    }

    private void setEmpty(long pageAddr) {
        this.setCount(pageAddr, 0);
    }

    public long getNextId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 48);
    }

    public void setNextId(long pageAddr, long nextId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 48, nextId);
    }

    public long getPreviousId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 40);
    }

    public void setPreviousId(long pageAddr, long prevId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 40, prevId);
    }

    public int getCount(long pageAddr) {
        return PageUtils.getShort(pageAddr, 56);
    }

    private void setCount(long pageAddr, int cnt) {
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, 56, (short)cnt);
    }

    private int getCapacity(int pageSize) {
        return pageSize - 58 >>> 3;
    }

    private int offset(int idx) {
        return 58 + 8 * idx;
    }

    public long getAt(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    private void setAt(long pageAddr, int idx, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, this.offset(idx), pageId);
    }

    public int addPage(long pageAddr, long pageId, int pageSize) {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        if (cnt == this.getCapacity(pageSize)) {
            return -1;
        }
        this.setAt(pageAddr, cnt, pageId);
        this.setCount(pageAddr, cnt + 1);
        return cnt;
    }

    public long takeAnyPage(long pageAddr) {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        if (cnt == 0) {
            return 0L;
        }
        this.setCount(pageAddr, --cnt);
        return this.getAt(pageAddr, cnt);
    }

    public boolean removePage(long pageAddr, long dataPageId) {
        assert (dataPageId != 0L);
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            if (PageIdUtils.maskPartitionId(this.getAt(pageAddr, i)) != PageIdUtils.maskPartitionId(dataPageId)) continue;
            if (i != cnt - 1) {
                PageUtils.copyMemory(pageAddr, (long)this.offset(i + 1), pageAddr, (long)this.offset(i), (long)(8 * (cnt - i - 1)));
            }
            this.setCount(pageAddr, cnt - 1);
            return true;
        }
        return false;
    }

    public boolean isEmpty(long pageAddr) {
        return this.getCount(pageAddr) == 0;
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("PagesListNode [\n\tpreviousPageId=").appendHex(this.getPreviousId(addr)).app(",\n\tnextPageId=").appendHex(this.getNextId(addr)).app(",\n\tcount=").app(this.getCount(addr)).app(",\n\tpages={");
        for (int i = 0; i < this.getCount(addr); ++i) {
            sb.app("\n\t\t").app(this.getAt(addr, i));
        }
        sb.app("\n\t}\n]");
    }
}

