import React from "react";
import _ from "lodash";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
export var ActionType;
(function (ActionType) {
    ActionType["SUBMIT"] = "submit";
    ActionType["BUTTON"] = "button";
    ActionType["RESET"] = "reset";
})(ActionType || (ActionType = {}));
export const convertActionsToButton = (actions, enabled, onSubmitForm) => {
    if (_.isEmpty(actions)) {
        return null;
    }
    const capitalize = (label) => {
        return label.charAt(0).toUpperCase() + label.slice(1);
    };
    const isPrimary = (label) => {
        return label.toLowerCase() === "complete" || label.toLowerCase() === "start" || (actions && actions.length === 1);
    };
    const resolveButtonVariant = (action) => {
        if (isPrimary(action.name)) {
            return "primary";
        }
        return "secondary";
    };
    const buttons = actions.map((action) => {
        const actionType = action.actionType ? action.actionType : ActionType.SUBMIT;
        return {
            key: `submit-${action.name}`,
            label: capitalize(action.name),
            variant: resolveButtonVariant(action),
            actionType: actionType,
            onClick: () => {
                action.execute && action.execute();
                actionType === ActionType.SUBMIT && onSubmitForm && onSubmitForm();
            },
        };
    });
    buttons.sort((buttonA, buttonB) => {
        if (isPrimary(buttonA.label)) {
            return -1;
        }
        if (isPrimary(buttonB.label)) {
            return 2;
        }
        return buttonA.label.localeCompare(buttonB.label);
    });
    return buttons.map((button) => {
        return (React.createElement(Button, { type: button.actionType, key: button.key, variant: button.variant, onClick: () => {
                if (enabled) {
                    button.onClick();
                }
            }, isDisabled: !enabled }, button.label));
    });
};
//# sourceMappingURL=FormActionsUtils.js.map