var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import _ from "lodash";
import * as React from "react";
import { useCallback, useImperativeHandle, useMemo, useRef } from "react";
import * as ReactTable from "react-table";
import { BeeTableHeaderVisibility } from "../../api";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { NavigationKeysUtils } from "../../keysUtils/keyUtils";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH } from "../../resizing/WidthConstants";
import { BeeTableBody } from "./BeeTableBody";
import { BeeTableResizableColumnsContextProvider, } from "../../resizing/BeeTableResizableColumnsContext";
import { BeeTableContextMenuHandler } from "./BeeTableContextMenuHandler";
import { BeeTableDefaultCell } from "./BeeTableDefaultCell";
import { BeeTableHeader } from "./BeeTableHeader";
import { BeeTableSelectionContextProvider, SELECTION_MIN_ACTIVE_DEPTH, SelectionPart, useBeeTableSelectionDispatch, } from "../../selection/BeeTableSelectionContext";
import { BeeTableCellWidthsToFitDataContextProvider } from "../../resizing/BeeTableCellWidthToFitDataContext";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
import "./BeeTable.css";
const ROW_INDEX_COLUMN_ACCESOR = "#";
const ROW_INDEX_SUB_COLUMN_ACCESSOR = "0";
export function getColumnsAtLastLevel(columns, depth = 0) {
    return _.flatMap(columns, (column) => {
        if (!column.columns) {
            return column;
        }
        return depth > 0
            ? getColumnsAtLastLevel(column.columns, depth - 1)
            : column.columns;
    });
}
export function BeeTableInternal({ selectionRef, tableId, additionalRow, editColumnLabel, isEditableHeader = true, onCellUpdates, onColumnUpdates, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, onColumnAdded, onColumnDeleted, onHeaderClick, onHeaderKeyUp, onDataCellClick, onDataCellKeyUp, controllerCell = ROW_INDEX_COLUMN_ACCESOR, cellComponentByColumnAccessor, rows, columns, operationConfig, allowedOperations, headerVisibility = BeeTableHeaderVisibility.AllLevels, headerLevelCountForAppendingRowIndexColumn = 0, skipLastHeaderGroup = false, getRowKey, getColumnKey, isReadOnly = false, enableKeyboardNavigation = true, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, shouldShowColumnsInlineControls, resizerStopBehavior, lastColumnMinWidth, rowWrapper, }) {
    const { resetSelectionAt, erase, copy, cut, paste, adaptSelection, mutateSelection, setCurrentDepth } = useBeeTableSelectionDispatch();
    const tableComposableRef = useRef(null);
    const { currentlyOpenContextMenu } = useBoxedExpressionEditor();
    const tableRef = React.useRef(null);
    const hasAdditionalRow = useMemo(() => {
        var _a;
        return ((_a = additionalRow === null || additionalRow === void 0 ? void 0 : additionalRow.length) !== null && _a !== void 0 ? _a : 0) > 0;
    }, [additionalRow === null || additionalRow === void 0 ? void 0 : additionalRow.length]);
    const addRowIndexColumnsRecursively = useCallback((column, headerLevelCount) => {
        var _a;
        if (headerLevelCount > 0) {
            _.assign(column, {
                columns: [
                    {
                        label: headerVisibility === BeeTableHeaderVisibility.AllLevels
                            ? ROW_INDEX_SUB_COLUMN_ACCESSOR
                            : controllerCell,
                        accessor: ROW_INDEX_SUB_COLUMN_ACCESSOR,
                        minWidth: BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
                        width: BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
                        isRowIndexColumn: true,
                        dataType: undefined,
                    },
                ],
            });
            if ((_a = column.columns) === null || _a === void 0 ? void 0 : _a.length) {
                addRowIndexColumnsRecursively(column.columns[0], headerLevelCount - 1);
            }
        }
    }, [controllerCell, headerVisibility]);
    const addRowIndexColumns = useCallback((currentControllerCell, columns) => {
        const rowIndexColumn = {
            label: currentControllerCell,
            accessor: ROW_INDEX_COLUMN_ACCESOR,
            width: BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
            minWidth: BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
            isRowIndexColumn: true,
            dataType: undefined,
        };
        addRowIndexColumnsRecursively(rowIndexColumn, headerLevelCountForAppendingRowIndexColumn);
        return [rowIndexColumn, ...columns];
    }, [addRowIndexColumnsRecursively, headerLevelCountForAppendingRowIndexColumn]);
    const columnsWithAddedIndexColumns = useMemo(() => addRowIndexColumns(controllerCell, columns), [addRowIndexColumns, columns, controllerCell]);
    const rowCount = useCallback((normalRowsCount) => {
        return normalRowsCount + (hasAdditionalRow ? 1 : 0);
    }, [hasAdditionalRow]);
    const _setActiveCellEditing = useCallback((rowCount, columnCount) => (isEditing) => {
        mutateSelection({
            part: SelectionPart.ActiveCell,
            columnCount,
            rowCount,
            deltaColumns: 0,
            deltaRows: 0,
            isEditingActiveCell: isEditing,
            keepInsideSelection: true,
        });
    }, [mutateSelection]);
    const _navigateVertically = useCallback((rowCount, columnCount) => (args) => {
        mutateSelection({
            part: SelectionPart.ActiveCell,
            columnCount,
            rowCount,
            deltaColumns: 0,
            deltaRows: args.isShiftPressed ? -1 : 1,
            isEditingActiveCell: false,
            keepInsideSelection: true,
        });
    }, [mutateSelection]);
    const _navigateHorizontally = useCallback((rowCount, columnCount) => (args) => {
        mutateSelection({
            part: SelectionPart.ActiveCell,
            columnCount,
            rowCount,
            deltaColumns: args.isShiftPressed ? -1 : 1,
            deltaRows: 0,
            isEditingActiveCell: false,
            keepInsideSelection: true,
        });
    }, [mutateSelection]);
    const defaultColumn = useMemo(() => ({
        Cell: (cellProps) => {
            var _a;
            const columnIndex = cellProps.allColumns.findIndex((c) => c.id === cellProps.column.id);
            const CellComponentForColumn = (_a = cellComponentByColumnAccessor === null || cellComponentByColumnAccessor === void 0 ? void 0 : cellComponentByColumnAccessor[cellProps.column.id]) !== null && _a !== void 0 ? _a : cellComponentByColumnAccessor === null || cellComponentByColumnAccessor === void 0 ? void 0 : cellComponentByColumnAccessor["___default"];
            if (CellComponentForColumn) {
                return (_jsx(CellComponentForColumn, { data: cellProps.data, rowIndex: cellProps.row.index, columnIndex: columnIndex, columnId: cellProps.column.id }));
            }
            else {
                return (_jsx(BeeTableDefaultCell, { columnIndex: columnIndex, cellProps: cellProps, onCellUpdates: onCellUpdates, isReadOnly: isReadOnly, setEditing: _setActiveCellEditing(cellProps.rows.length, () => cellProps.allColumns.length), navigateHorizontally: _navigateHorizontally(cellProps.rows.length, () => cellProps.allColumns.length), navigateVertically: _navigateVertically(cellProps.rows.length, () => cellProps.allColumns.length) }));
            }
        },
    }), [
        cellComponentByColumnAccessor,
        onCellUpdates,
        isReadOnly,
        _setActiveCellEditing,
        _navigateHorizontally,
        _navigateVertically,
    ]);
    const reactTableInstance = ReactTable.useTable({
        columns: columnsWithAddedIndexColumns,
        data: rows,
        defaultColumn,
    }, ReactTable.useBlockLayout);
    const onGetColumnKey = useCallback((column) => {
        return getColumnKey ? getColumnKey(column) : column.originalId || column.id;
    }, [getColumnKey]);
    const onGetRowKey = useCallback((row) => {
        if (getRowKey) {
            return getRowKey(row);
        }
        else {
            if (row.original) {
                return row.original.id;
            }
            return row.id;
        }
    }, [getRowKey]);
    const getColumnCount = useCallback((rowIndex) => {
        if (rowIndex >= 0) {
            return reactTableInstance.allColumns.length;
        }
        else {
            return _.nth(reactTableInstance.headerGroups, rowIndex).headers.reduce((acc, column) => acc + (column.placeholderOf ? 0 : 1), 0);
        }
    }, [reactTableInstance.allColumns.length, reactTableInstance.headerGroups]);
    const onKeyDown = useCallback((e) => {
        if (!enableKeyboardNavigation) {
            return;
        }
        if (currentlyOpenContextMenu) {
            return;
        }
        if (NavigationKeysUtils.isEnter(e.key) && !e.metaKey && !e.altKey && !e.ctrlKey) {
            e.stopPropagation();
            e.preventDefault();
            setCurrentDepth((prev) => {
                var _a, _b;
                const newActiveDepth = Math.min(prev.max, ((_a = prev.active) !== null && _a !== void 0 ? _a : SELECTION_MIN_ACTIVE_DEPTH) + 1);
                if (((_b = prev.active) !== null && _b !== void 0 ? _b : SELECTION_MIN_ACTIVE_DEPTH) < prev.max) {
                    return {
                        max: prev.max,
                        active: newActiveDepth,
                    };
                }
                mutateSelection({
                    part: SelectionPart.ActiveCell,
                    columnCount: getColumnCount,
                    rowCount: rowCount(reactTableInstance.rows.length),
                    deltaColumns: 0,
                    deltaRows: 0,
                    isEditingActiveCell: true,
                    keepInsideSelection: true,
                });
                return prev;
            });
        }
        if (NavigationKeysUtils.isTab(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            if (e.shiftKey) {
                mutateSelection({
                    part: SelectionPart.ActiveCell,
                    columnCount: getColumnCount,
                    rowCount: rowCount(reactTableInstance.rows.length),
                    deltaColumns: -1,
                    deltaRows: 0,
                    isEditingActiveCell: false,
                    keepInsideSelection: true,
                });
            }
            else {
                mutateSelection({
                    part: SelectionPart.ActiveCell,
                    columnCount: getColumnCount,
                    rowCount: rowCount(reactTableInstance.rows.length),
                    deltaColumns: 1,
                    deltaRows: 0,
                    isEditingActiveCell: false,
                    keepInsideSelection: true,
                });
            }
        }
        const selectionPart = e.shiftKey ? SelectionPart.SelectionEnd : SelectionPart.ActiveCell;
        if (NavigationKeysUtils.isArrowLeft(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            mutateSelection({
                part: selectionPart,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: -1,
                deltaRows: 0,
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
        }
        if (NavigationKeysUtils.isArrowRight(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            mutateSelection({
                part: selectionPart,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: 1,
                deltaRows: 0,
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
        }
        if (NavigationKeysUtils.isArrowUp(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            mutateSelection({
                part: selectionPart,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: 0,
                deltaRows: -1,
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
        }
        if (NavigationKeysUtils.isArrowDown(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            mutateSelection({
                part: selectionPart,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: 0,
                deltaRows: 1,
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
        }
        if (NavigationKeysUtils.isDelete(e.key) || NavigationKeysUtils.isBackspace(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            erase();
        }
        if (NavigationKeysUtils.isEsc(e.key)) {
            e.stopPropagation();
            e.preventDefault();
            resetSelectionAt(undefined);
        }
        const complementaryKey = (getOperatingSystem() === OperatingSystem.MACOS && e.metaKey) ||
            (getOperatingSystem() !== OperatingSystem.MACOS && e.ctrlKey);
        if (!e.shiftKey && complementaryKey && e.key.toLowerCase() === "c") {
            e.stopPropagation();
            e.preventDefault();
            copy();
        }
        if (!e.shiftKey && complementaryKey && e.key.toLowerCase() === "x") {
            e.stopPropagation();
            e.preventDefault();
            cut();
        }
        if (!e.shiftKey && complementaryKey && e.key.toLowerCase() === "v") {
            e.stopPropagation();
            e.preventDefault();
            paste();
        }
        if (!e.shiftKey && complementaryKey && e.key.toLowerCase() === "a") {
            e.stopPropagation();
            e.preventDefault();
            mutateSelection({
                part: SelectionPart.SelectionStart,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: -(reactTableInstance.allColumns.length - 1),
                deltaRows: -(reactTableInstance.rows.length - 1),
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
            mutateSelection({
                part: SelectionPart.SelectionEnd,
                columnCount: getColumnCount,
                rowCount: rowCount(reactTableInstance.rows.length),
                deltaColumns: +(reactTableInstance.allColumns.length - 1),
                deltaRows: +(reactTableInstance.rows.length - 1),
                isEditingActiveCell: false,
                keepInsideSelection: false,
            });
        }
    }, [
        enableKeyboardNavigation,
        currentlyOpenContextMenu,
        setCurrentDepth,
        mutateSelection,
        rowCount,
        reactTableInstance.allColumns.length,
        reactTableInstance.rows.length,
        getColumnCount,
        erase,
        resetSelectionAt,
        copy,
        cut,
        paste,
    ]);
    const onRowAdded2 = useCallback((args) => {
        if (onRowAdded) {
            onRowAdded(args);
            adaptSelection({
                atRowIndex: args.beforeIndex,
                rowCountDelta: args.rowsCount,
                atColumnIndex: -1,
                columnCountDelta: 0,
            });
        }
    }, [adaptSelection, onRowAdded]);
    const onColumnAdded2 = useCallback((args) => {
        if (onColumnAdded) {
            onColumnAdded(args);
            adaptSelection({
                atRowIndex: -1,
                rowCountDelta: 0,
                atColumnIndex: args.beforeIndex + 1,
                columnCountDelta: args.columnsCount,
            });
        }
    }, [adaptSelection, onColumnAdded]);
    const onRowDuplicated2 = useCallback((args) => {
        if (onRowDuplicated) {
            onRowDuplicated(args);
            adaptSelection({
                atRowIndex: args.rowIndex,
                rowCountDelta: 1,
                atColumnIndex: -1,
                columnCountDelta: 0,
            });
        }
    }, [adaptSelection, onRowDuplicated]);
    const onRowDeleted2 = useCallback((args) => {
        if (onRowDeleted) {
            onRowDeleted(args);
            adaptSelection({
                atRowIndex: args.rowIndex,
                rowCountDelta: -1,
                atColumnIndex: -1,
                columnCountDelta: 0,
            });
        }
    }, [adaptSelection, onRowDeleted]);
    const onColumnDeleted2 = useCallback((args) => {
        if (onColumnDeleted) {
            onColumnDeleted(args);
            adaptSelection({
                atRowIndex: -1,
                rowCountDelta: 0,
                atColumnIndex: args.columnIndex + 1,
                columnCountDelta: -1,
            });
        }
    }, [adaptSelection, onColumnDeleted]);
    const setActiveCellEditing = useMemo(() => {
        return _setActiveCellEditing(reactTableInstance.rows.length, () => reactTableInstance.allColumns.length);
    }, [_setActiveCellEditing, reactTableInstance.allColumns.length, reactTableInstance.rows.length]);
    useImperativeHandle(selectionRef, () => ({
        setActiveCellEditing: (isEditing) => setActiveCellEditing(isEditing),
    }), [setActiveCellEditing]);
    return (_jsxs("div", Object.assign({ className: `table-component ${tableId}`, ref: tableRef, onKeyDown: onKeyDown }, { children: [_jsxs("table", Object.assign({}, reactTableInstance.getTableProps(), { ref: tableComposableRef, "data-ouia-component-id": "expression-grid-table" }, { children: [_jsx(BeeTableHeader, { resizerStopBehavior: resizerStopBehavior, shouldRenderRowIndexColumn: shouldRenderRowIndexColumn, shouldShowRowsInlineControls: shouldShowColumnsInlineControls, editColumnLabel: editColumnLabel, isEditableHeader: isEditableHeader, getColumnKey: onGetColumnKey, headerVisibility: headerVisibility, onColumnUpdates: onColumnUpdates, skipLastHeaderGroup: skipLastHeaderGroup, tableColumns: columnsWithAddedIndexColumns, reactTableInstance: reactTableInstance, onColumnAdded: onColumnAdded2, onHeaderClick: onHeaderClick, onHeaderKeyUp: onHeaderKeyUp, lastColumnMinWidth: lastColumnMinWidth, setActiveCellEditing: setActiveCellEditing }), _jsx(BeeTableBody, { rowWrapper: rowWrapper, resizerStopBehavior: resizerStopBehavior, shouldRenderRowIndexColumn: shouldRenderRowIndexColumn, shouldShowRowsInlineControls: shouldShowRowsInlineControls, getColumnKey: onGetColumnKey, getRowKey: onGetRowKey, headerVisibility: headerVisibility, reactTableInstance: reactTableInstance, additionalRow: additionalRow, onRowAdded: onRowAdded2, onDataCellClick: onDataCellClick, onDataCellKeyUp: onDataCellKeyUp, lastColumnMinWidth: lastColumnMinWidth })] })), _jsx(BeeTableContextMenuHandler, { tableRef: tableRef, operationConfig: operationConfig, allowedOperations: allowedOperations, reactTableInstance: reactTableInstance, onRowAdded: onRowAdded2, onRowDuplicated: onRowDuplicated2, onRowDeleted: onRowDeleted2, onColumnAdded: onColumnAdded2, onColumnDeleted: onColumnDeleted2, onRowReset: onRowReset })] })));
}
export const BeeTable = (_a) => {
    var { forwardRef, onColumnResizingWidthChange } = _a, props = __rest(_a, ["forwardRef", "onColumnResizingWidthChange"]);
    const beeTableResizingRef = useRef(null);
    const beeTableSelectionRef = useRef(null);
    useImperativeHandle(forwardRef, () => {
        if (!beeTableResizingRef.current || !beeTableSelectionRef.current) {
            return null;
        }
        return Object.assign(Object.assign({}, beeTableSelectionRef.current), beeTableResizingRef.current);
    }, []);
    return (_jsx(BeeTableSelectionContextProvider, { children: _jsx(BeeTableResizableColumnsContextProvider, Object.assign({ resizingRef: beeTableResizingRef, onChange: onColumnResizingWidthChange }, { children: _jsx(BeeTableCellWidthsToFitDataContextProvider, { children: _jsx(BeeTableInternal, Object.assign({}, props, { selectionRef: beeTableSelectionRef })) }) })) }));
};
//# sourceMappingURL=BeeTable.js.map