"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputFieldRowAction = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var trash_icon_1 = require("@patternfly/react-icons/dist/js/icons/trash-icon");
var OutputFieldRowAction = function (props) {
    var index = props.index, onDelete = props.onDelete;
    var handleDelete = function (e, interaction) {
        e.stopPropagation();
        e.preventDefault();
        if (onDelete) {
            onDelete(interaction);
        }
    };
    return ((0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" }, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "output-field-n".concat(index, "__delete"), "data-testid": "output-field-n".concat(index, "__delete"), className: "editable-item__delete", variant: "plain", onClick: function (e) { return handleDelete(e, "mouse"); }, onKeyDown: function (event) {
                    if (event.key === "Enter") {
                        handleDelete(event, "keyboard");
                    }
                } }, { children: (0, jsx_runtime_1.jsx)(trash_icon_1.TrashIcon, {}) })) }) })));
};
exports.OutputFieldRowAction = OutputFieldRowAction;
//# sourceMappingURL=OutputFieldRowAction.js.map