"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.areAttributesReasonCodesMissing = exports.validateAttributes = exports.validateAttribute = void 0;
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateAttribute = function (modelIndex, scorecardProperties, characteristicIndex, characteristic, isPartialScoreRequired, attributeIndex, attribute, miningFields, validationRegistry) {
    if (scorecardProperties.useReasonCodes !== false &&
        characteristic.reasonCode === undefined &&
        attribute.reasonCode === undefined) {
        validationRegistry.set((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forReasonCode()
            .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(characteristic.name, " attribute: Reason code is required.")));
    }
    if (isPartialScoreRequired && attribute.partialScore === undefined) {
        validationRegistry.set((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPartialScore()
            .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(characteristic.name, " attribute: Partial score is required.")));
    }
    var fieldNames = miningFields.map(function (miningField) { return miningField.name; });
    validatePredicate((0, paths_1.Builder)()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPredicate(), attribute.predicate, fieldNames, validationRegistry);
};
exports.validateAttribute = validateAttribute;
var validateAttributes = function (modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry) {
    var isPartialScoreRequired = characteristic.Attribute.filter(function (attribute) { return attribute.partialScore !== undefined; }).length > 0;
    characteristic.Attribute.forEach(function (attribute, attributeIndex) {
        return (0, exports.validateAttribute)(modelIndex, scorecardProperties, characteristicIndex, characteristic, isPartialScoreRequired, attributeIndex, attribute, miningFields, validationRegistry);
    });
};
exports.validateAttributes = validateAttributes;
var validatePredicate = function (pathBuilder, predicate, fieldNames, validationRegistry) {
    var _a;
    if (predicate === undefined) {
        validationRegistry.set(pathBuilder.build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "No predicate defined."));
        return;
    }
    else if (predicate instanceof pmml_editor_marshaller_1.True) {
        return;
    }
    else if (predicate instanceof pmml_editor_marshaller_1.False) {
        return;
    }
    else if (predicate instanceof pmml_editor_marshaller_1.SimpleSetPredicate) {
        if (fieldNames.filter(function (fieldName) { return fieldName === predicate.field; }).length === 0) {
            validationRegistry.set(pathBuilder.forFieldName().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(predicate.field, "\" cannot be found in the Mining Schema.")));
        }
    }
    else if (predicate instanceof pmml_editor_marshaller_1.SimplePredicate) {
        if (fieldNames.filter(function (fieldName) { return fieldName === predicate.field; }).length === 0) {
            validationRegistry.set(pathBuilder.forFieldName().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(predicate.field, "\" cannot be found in the Mining Schema.")));
        }
    }
    else if (predicate instanceof pmml_editor_marshaller_1.CompoundPredicate) {
        (_a = predicate.predicates) === null || _a === void 0 ? void 0 : _a.forEach(function (p, i) {
            return validatePredicate(pathBuilder.forPredicate(i), p, fieldNames, validationRegistry);
        });
    }
};
var areAttributesReasonCodesMissing = function (attributes) {
    if (attributes.length === 0) {
        return true;
    }
    return !attributes.every(function (attribute) { return attribute.reasonCode !== undefined; });
};
exports.areAttributesReasonCodesMissing = areAttributesReasonCodesMissing;
//# sourceMappingURL=Attributes.js.map