/// <reference types="react" />
import { NodeInstance } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { WorkflowDetailsDriver } from "../api";
import { Job, JobStatus, WorkflowInstance, WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export declare const JobsIconCreator: (state: JobStatus) => JSX.Element;
export declare const handleRetry: (workflowInstance: WorkflowInstance, drive: WorkflowDetailsDriver, onRetrySuccess: () => void, onRetryFailure: (errorMessage: string) => void) => Promise<void>;
export declare const handleSkip: (workflowInstance: WorkflowInstance, drive: WorkflowDetailsDriver, onSkipSuccess: () => void, onSkipFailure: (errorMessage: string) => void) => Promise<void>;
export declare const handleNodeInstanceRetrigger: (workflowInstance: WorkflowInstance, driver: WorkflowDetailsDriver, node: NodeInstance, onRetriggerSuccess: () => void, onRetriggerFailure: (errorMessage: string) => void) => void;
export declare const handleNodeInstanceCancel: (workflowInstance: WorkflowInstance, driver: WorkflowDetailsDriver, node: NodeInstance, onCancelSuccess: () => void, onCancelFailure: (errorMessage: string) => void) => void;
export declare const jobCancel: (drive: WorkflowDetailsDriver, job: Pick<Job, "id" | "endpoint">, setModalTitle: (title: JSX.Element) => void, setModalContent: (content: string) => void) => Promise<void>;
export declare const handleJobRescheduleUtil: (repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date, selectedJob: Job, handleRescheduleAction: () => void, driver: WorkflowDetailsDriver, setRescheduleError: (modalContent: string) => void) => Promise<void>;
export declare const getWorkflowInstanceDescription: (workflowInstance: WorkflowInstance) => {
    id: string;
    name: string | undefined;
    description: string | undefined;
};
export declare const WorkflowInstanceIconCreator: (state: WorkflowInstanceState) => JSX.Element;
//# sourceMappingURL=Utils.d.ts.map