import "@patternfly/react-core/dist/styles/base.css";
import "reactflow/dist/style.css";
import * as React from "react";
import { PMML } from "@kie-tools/pmml-editor-marshaller";
import { DmnLatestModel, AllDmnMarshallers } from "@kie-tools/dmn-marshaller";
import { Normalized } from "./normalization/normalize";
import "@kie-tools/dmn-marshaller/dist/kie-extensions";
import "./DmnEditor.css";
import { Commands } from "./commands/CommandsContextProvider";
export declare type DmnEditorRef = {
    reset: (mode: DmnLatestModel) => void;
    getDiagramSvg: () => Promise<string | undefined>;
    getCommands: () => Commands;
};
export declare type EvaluationResults = Record<string, any>;
export declare type ValidationMessages = Record<string, any>;
export declare type OnDmnModelChange = (model: Normalized<DmnLatestModel>) => void;
export declare type OnRequestToJumpToPath = (normalizedPosixPathRelativeToTheOpenFile: string) => void;
export declare type OnRequestToResolvePath = (normalizedPosixPathRelativeToTheOpenFile: string) => string;
export declare type OnRequestExternalModelsAvailableToInclude = () => Promise<string[]>;
export declare type OnRequestExternalModelByPath = (normalizedPosixPathRelativeToTheOpenFile: string) => Promise<ExternalModel | null>;
export declare type ExternalModelsIndex = Record<string, ExternalModel | undefined>;
export declare type ExternalModel = ({
    type: "dmn";
} & ExternalDmn) | ({
    type: "pmml";
} & ExternalPmml);
export declare type ExternalDmnsIndex = Map<string, ExternalDmn>;
export declare type ExternalDmn = {
    model: Normalized<DmnLatestModel>;
    normalizedPosixPathRelativeToTheOpenFile: string;
    svg: string;
};
export declare type ExternalPmmlsIndex = Map<string, ExternalPmml>;
export declare type ExternalPmml = {
    model: PMML;
    normalizedPosixPathRelativeToTheOpenFile: string;
};
export declare type DmnEditorProps = {
    model: DmnLatestModel;
    originalVersion?: AllDmnMarshallers["version"];
    onModelChange?: OnDmnModelChange;
    onRequestExternalModelByPath?: OnRequestExternalModelByPath;
    onRequestExternalModelsAvailableToInclude?: OnRequestExternalModelsAvailableToInclude;
    externalModelsByNamespace?: ExternalModelsIndex;
    evaluationResults?: EvaluationResults;
    validationMessages?: ValidationMessages;
    externalContextName?: string;
    externalContextDescription?: string;
    issueTrackerHref?: string;
    onRequestToJumpToPath?: OnRequestToJumpToPath;
    onRequestToResolvePath?: OnRequestToResolvePath;
    onModelDebounceStateChanged?: (changed: boolean) => void;
};
export declare const DmnEditorInternal: ({ model, originalVersion, onModelChange, onModelDebounceStateChanged, forwardRef, }: DmnEditorProps & {
    forwardRef?: React.Ref<DmnEditorRef> | undefined;
}) => JSX.Element;
export declare const DmnEditor: React.ForwardRefExoticComponent<DmnEditorProps & React.RefAttributes<DmnEditorRef>>;
export declare function usePrevious<T>(value: T): T;
export declare function useStateAsItWasBeforeConditionBecameTrue<T>(state: T, condition: boolean, set: (prev: T) => void): void;
//# sourceMappingURL=DmnEditor.d.ts.map