var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import * as RF from "reactflow";
import { useEffect } from "react";
import { DMN_EDITOR_DIAGRAM_CLIPBOARD_MIME_TYPE, buildClipboardFromDiagram, getClipboard, } from "../clipboard/Clipboard";
import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
import { NodeNature, nodeNatures } from "../mutations/NodeNature";
import { addOrGetDrd } from "../mutations/addOrGetDrd";
import { addStandaloneNode } from "../mutations/addStandaloneNode";
import { EdgeDeletionMode, deleteEdge } from "../mutations/deleteEdge";
import { NodeDeletionMode, canRemoveNodeFromDrdOnly, deleteNode } from "../mutations/deleteNode";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "../mutations/repopulateInputDataAndDecisionsOnDecisionService";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { CONTAINER_NODES_DESIRABLE_PADDING, getBounds } from "./maths/DmnMaths";
import { NODE_TYPES } from "./nodes/NodeTypes";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
import { DEFAULT_VIEWPORT } from "./Diagram";
import { useCommands } from "../commands/CommandsContextProvider";
export function DiagramCommands(props) {
    var _this = this;
    var rfStoreApi = RF.useStoreApi();
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var commandsRef = useCommands().commandsRef;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var rf = RF.useReactFlow();
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.cancelAction = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Canceling action...");
                rfStoreApi.setState(function (rfState) {
                    var _a, _b;
                    if (rfState.connectionNodeId) {
                        rfState.cancelConnection();
                        dmnEditorStoreApi.setState(function (state) {
                            state.diagram.ongoingConnection = undefined;
                        });
                    }
                    else {
                        (_b = (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur) === null || _b === void 0 ? void 0 : _b.call(_a);
                    }
                    return rfState;
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef, rfStoreApi]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.resetPosition = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Reseting position...");
                rf.setViewport(DEFAULT_VIEWPORT, { duration: 200 });
                return [2];
            });
        }); };
    }, [commandsRef, rf]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.focusOnSelection = function () { return __awaiter(_this, void 0, void 0, function () {
            var selectedNodes, bounds;
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Focusing on selected bounds...");
                selectedNodes = rf.getNodes().filter(function (s) { return s.selected; });
                if (selectedNodes.length <= 0) {
                    return [2];
                }
                bounds = getBounds({
                    nodes: selectedNodes,
                    padding: 100,
                });
                rf.fitBounds({
                    x: bounds["@_x"],
                    y: bounds["@_y"],
                    width: bounds["@_width"],
                    height: bounds["@_height"],
                }, { duration: 200 });
                return [2];
            });
        }); };
    }, [commandsRef, rf]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.cut = function () { return __awaiter(_this, void 0, void 0, function () {
            var _a, clipboard, copiedEdgesById, danglingEdgesById, copiedNodesById;
            return __generator(this, function (_b) {
                console.debug("DMN DIAGRAM: COMMANDS: Cutting selected nodes...");
                _a = buildClipboardFromDiagram(rfStoreApi.getState(), dmnEditorStoreApi.getState()), clipboard = _a.clipboard, copiedEdgesById = _a.copiedEdgesById, danglingEdgesById = _a.danglingEdgesById, copiedNodesById = _a.copiedNodesById;
                navigator.clipboard.writeText(JSON.stringify(clipboard)).then(function () {
                    dmnEditorStoreApi.setState(function (state) {
                        __spreadArray(__spreadArray([], __read(copiedEdgesById.values()), false), __read(danglingEdgesById.values()), false).forEach(function (edge) {
                            deleteEdge({
                                definitions: state.dmn.model.definitions,
                                drdIndex: state.computed(state).getDrdIndex(),
                                edge: { id: edge.id, dmnObject: edge.data.dmnObject },
                                mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                            });
                            state.dispatch(state).diagram.setEdgeStatus(edge.id, {
                                selected: false,
                                draggingWaypoint: false,
                            });
                        });
                        rfStoreApi
                            .getState()
                            .getNodes()
                            .forEach(function (node) {
                            var _a, _b;
                            if (copiedNodesById.has(node.id)) {
                                deleteNode({
                                    __readonly_drgEdges: state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges,
                                    definitions: state.dmn.model.definitions,
                                    __readonly_drdIndex: state.computed(state).getDrdIndex(),
                                    __readonly_dmnObjectNamespace: (_a = node.data.dmnObjectNamespace) !== null && _a !== void 0 ? _a : state.dmn.model.definitions["@_namespace"],
                                    __readonly_dmnObjectQName: node.data.dmnObjectQName,
                                    __readonly_dmnObjectId: (_b = node.data.dmnObject) === null || _b === void 0 ? void 0 : _b["@_id"],
                                    __readonly_nodeNature: nodeNatures[node.type],
                                    mode: NodeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                                    __readonly_externalModelTypesByNamespace: state
                                        .computed(state)
                                        .getExternalModelTypesByNamespace(externalModelsByNamespace),
                                });
                                state.dispatch(state).diagram.setNodeStatus(node.id, {
                                    selected: false,
                                    dragging: false,
                                    resizing: false,
                                });
                            }
                        });
                    });
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, externalModelsByNamespace, commandsRef, rfStoreApi]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.copy = function () { return __awaiter(_this, void 0, void 0, function () {
            var clipboard;
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Copying selected nodes...");
                clipboard = buildClipboardFromDiagram(rfStoreApi.getState(), dmnEditorStoreApi.getState()).clipboard;
                navigator.clipboard.writeText(JSON.stringify(clipboard));
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef, rfStoreApi]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.paste = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Pasting nodes...");
                navigator.clipboard.readText().then(function (text) {
                    var clipboard = getClipboard(text, DMN_EDITOR_DIAGRAM_CLIPBOARD_MIME_TYPE);
                    if (!clipboard) {
                        return;
                    }
                    getNewDmnIdRandomizer()
                        .ack({
                        json: clipboard.drgElements,
                        type: "DMN15__tDefinitions",
                        attr: "drgElement",
                    })
                        .ack({
                        json: clipboard.artifacts,
                        type: "DMN15__tDefinitions",
                        attr: "artifact",
                    })
                        .ack({
                        json: clipboard.shapes,
                        type: "DMNDI15__DMNDiagram",
                        attr: "dmndi:DMNDiagramElement",
                        __$$element: "dmndi:DMNShape",
                    })
                        .ack({
                        json: clipboard.edges,
                        type: "DMNDI15__DMNDiagram",
                        attr: "dmndi:DMNDiagramElement",
                        __$$element: "dmndi:DMNEdge",
                    })
                        .ack({
                        json: clipboard.widths,
                        type: "KIE__tComponentsWidthsExtension",
                        attr: "kie:ComponentWidths",
                    })
                        .randomize({ skipAlreadyAttributedIds: false });
                    dmnEditorStoreApi.setState(function (state) {
                        var _a, _b;
                        var _c, _d;
                        var _e, _f;
                        (_c = (_e = state.dmn.model.definitions).drgElement) !== null && _c !== void 0 ? _c : (_e.drgElement = []);
                        (_a = state.dmn.model.definitions.drgElement).push.apply(_a, __spreadArray([], __read(clipboard.drgElements), false));
                        (_d = (_f = state.dmn.model.definitions).artifact) !== null && _d !== void 0 ? _d : (_f.artifact = []);
                        (_b = state.dmn.model.definitions.artifact).push.apply(_b, __spreadArray([], __read(clipboard.artifacts), false));
                        var _g = addOrGetDrd({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                        }), diagramElements = _g.diagramElements, widths = _g.widths;
                        diagramElements.push.apply(diagramElements, __spreadArray([], __read(clipboard.shapes.map(function (s) { return (__assign(__assign({}, s), { __$$element: "dmndi:DMNShape" })); })), false));
                        diagramElements.push.apply(diagramElements, __spreadArray([], __read(clipboard.edges.map(function (s) { return (__assign(__assign({}, s), { __$$element: "dmndi:DMNEdge" })); })), false));
                        widths.push.apply(widths, __spreadArray([], __read(clipboard.widths), false));
                        repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions: state.dmn.model.definitions });
                        state.diagram._selectedNodes = __spreadArray(__spreadArray([], __read(clipboard.drgElements), false), __read(clipboard.artifacts), false).map(function (s) {
                            return buildXmlHref({ id: s["@_id"] });
                        });
                        if (state.diagram._selectedNodes.length === 1) {
                            state.focus.consumableId = parseXmlHref(state.diagram._selectedNodes[0]).id;
                        }
                    });
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.selectAll = function () { return __awaiter(_this, void 0, void 0, function () {
            var allNodeIds, allEdgeIds;
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Selecting/Deselecting nodes...");
                allNodeIds = rfStoreApi
                    .getState()
                    .getNodes()
                    .map(function (s) { return s.id; });
                allEdgeIds = rfStoreApi.getState().edges.map(function (s) { return s.id; });
                dmnEditorStoreApi.setState(function (state) {
                    var allSelectedNodesSet = new Set(state.diagram._selectedNodes);
                    var allSelectedEdgesSet = new Set(state.diagram._selectedEdges);
                    if (allNodeIds.every(function (id) { return allSelectedNodesSet.has(id) && allEdgeIds.every(function (id) { return allSelectedEdgesSet.has(id); }); })) {
                        state.diagram._selectedNodes = [];
                        state.diagram._selectedEdges = [];
                    }
                    else {
                        state.diagram._selectedNodes = allNodeIds;
                        state.diagram._selectedEdges = allEdgeIds;
                    }
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef, rfStoreApi]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.createGroup = function () { return __awaiter(_this, void 0, void 0, function () {
            var selectedNodes;
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Grouping nodes...");
                selectedNodes = rf.getNodes().filter(function (s) { return s.selected; });
                if (selectedNodes.length <= 0) {
                    return [2];
                }
                dmnEditorStoreApi.setState(function (state) {
                    if (state.diagram._selectedNodes.length <= 0) {
                        return;
                    }
                    var newNodeId = addStandaloneNode({
                        definitions: state.dmn.model.definitions,
                        drdIndex: state.computed(state).getDrdIndex(),
                        newNode: {
                            type: NODE_TYPES.group,
                            bounds: getBounds({
                                nodes: selectedNodes,
                                padding: CONTAINER_NODES_DESIRABLE_PADDING,
                            }),
                        },
                    }).href;
                    state.dispatch(state).diagram.setNodeStatus(newNodeId, { selected: true });
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef, rf]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.toggleHierarchyHighlight = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Toggle hierarchy highlights...");
                dmnEditorStoreApi.setState(function (state) {
                    state.diagram.overlays.enableNodeHierarchyHighlight = !state.diagram.overlays.enableNodeHierarchyHighlight;
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.togglePropertiesPanel = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Toggle properties panel...");
                dmnEditorStoreApi.setState(function (state) {
                    state.diagram.propertiesPanel.isOpen = !state.diagram.propertiesPanel.isOpen;
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, commandsRef]);
    useEffect(function () {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.hideFromDrd = function () { return __awaiter(_this, void 0, void 0, function () {
            var nodesById;
            return __generator(this, function (_a) {
                console.debug("DMN DIAGRAM: COMMANDS: Hide node from DRD...");
                nodesById = rf
                    .getNodes()
                    .reduce(function (acc, s) { return acc.set(s.id, s); }, new Map());
                dmnEditorStoreApi.setState(function (state) {
                    var e_1, _a, e_2, _b;
                    var _c, _d, _e, _f, _g, _h;
                    var selectedNodeIds = new Set(state.diagram._selectedNodes);
                    try {
                        for (var _j = __values(rf.getEdges()), _k = _j.next(); !_k.done; _k = _j.next()) {
                            var edge = _k.value;
                            if ((selectedNodeIds.has(edge.source) &&
                                canRemoveNodeFromDrdOnly({
                                    __readonly_externalDmnsIndex: state
                                        .computed(state)
                                        .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                                    definitions: state.dmn.model.definitions,
                                    __readonly_drdIndex: state.computed(state).getDrdIndex(),
                                    __readonly_dmnObjectNamespace: (_c = nodesById.get(edge.source).data.dmnObjectNamespace) !== null && _c !== void 0 ? _c : state.dmn.model.definitions["@_namespace"],
                                    __readonly_dmnObjectId: (_d = nodesById.get(edge.source).data.dmnObject) === null || _d === void 0 ? void 0 : _d["@_id"],
                                })) ||
                                (selectedNodeIds.has(edge.target) &&
                                    canRemoveNodeFromDrdOnly({
                                        __readonly_externalDmnsIndex: state
                                            .computed(state)
                                            .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                                        definitions: state.dmn.model.definitions,
                                        __readonly_drdIndex: state.computed(state).getDrdIndex(),
                                        __readonly_dmnObjectNamespace: (_e = nodesById.get(edge.target).data.dmnObjectNamespace) !== null && _e !== void 0 ? _e : state.dmn.model.definitions["@_namespace"],
                                        __readonly_dmnObjectId: (_f = nodesById.get(edge.target).data.dmnObject) === null || _f === void 0 ? void 0 : _f["@_id"],
                                    }))) {
                                deleteEdge({
                                    definitions: state.dmn.model.definitions,
                                    drdIndex: state.computed(state).getDrdIndex(),
                                    edge: { id: edge.id, dmnObject: edge.data.dmnObject },
                                    mode: EdgeDeletionMode.FROM_CURRENT_DRD_ONLY,
                                });
                                state.dispatch(state).diagram.setEdgeStatus(edge.id, { selected: false, draggingWaypoint: false });
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_k && !_k.done && (_a = _j.return)) _a.call(_j);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    try {
                        for (var _l = __values(rf.getNodes().filter(function (s) { return s.selected; })), _m = _l.next(); !_m.done; _m = _l.next()) {
                            var node = _m.value;
                            if (nodeNatures[node.type] === NodeNature.ARTIFACT) {
                                continue;
                            }
                            var deletedShape = deleteNode({
                                definitions: state.dmn.model.definitions,
                                __readonly_drgEdges: [],
                                __readonly_externalModelTypesByNamespace: state
                                    .computed(state)
                                    .getExternalModelTypesByNamespace(externalModelsByNamespace),
                                __readonly_drdIndex: state.computed(state).getDrdIndex(),
                                __readonly_dmnObjectNamespace: (_g = node.data.dmnObjectNamespace) !== null && _g !== void 0 ? _g : state.dmn.model.definitions["@_namespace"],
                                __readonly_dmnObjectQName: node.data.dmnObjectQName,
                                __readonly_dmnObjectId: (_h = node.data.dmnObject) === null || _h === void 0 ? void 0 : _h["@_id"],
                                __readonly_nodeNature: nodeNatures[node.type],
                                mode: NodeDeletionMode.FROM_CURRENT_DRD_ONLY,
                            }).deletedDmnShapeOnCurrentDrd;
                            if (deletedShape) {
                                state.dispatch(state).diagram.setNodeStatus(node.id, {
                                    selected: false,
                                    dragging: false,
                                    resizing: false,
                                });
                            }
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_m && !_m.done && (_b = _l.return)) _b.call(_l);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                });
                return [2];
            });
        }); };
    }, [dmnEditorStoreApi, externalModelsByNamespace, commandsRef, rf]);
    return _jsx(_Fragment, {});
}
//# sourceMappingURL=DiagramCommands.js.map