var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { addOrGetDrd, getDefaultDrdName } from "../mutations/addOrGetDrd";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { DiagramLhsPanel } from "../store/Store";
import { getDrdId } from "./drd/drdId";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Form, FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { AlternativeInputDataIcon, InputDataIcon } from "../icons/Icons";
import { EmptyState, EmptyStateBody } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { useCallback } from "react";
export function DrdSelectorPanel() {
    var _a, _b;
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var drdIndex = useDmnEditorStore(function (s) { return s.computed(s).getDrdIndex(); });
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var drdName = useDmnEditorStore(function (s) {
        var _a, _b, _c;
        return ((_c = (_b = (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[s.computed(s).getDrdIndex()]) === null || _c === void 0 ? void 0 : _c["@_name"]) ||
            getDefaultDrdName({ drdIndex: s.computed(s).getDrdIndex() });
    });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var drds = (_b = (_a = thisDmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) !== null && _b !== void 0 ? _b : [];
    var removeDrd = useCallback(function () {
        dmnEditorStoreApi.setState(function (s) {
            var _a, _b;
            var nextDrds = (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"];
            nextDrds === null || nextDrds === void 0 ? void 0 : nextDrds.splice(s.computed(s).getDrdIndex(), 1);
            s.diagram.__unsafeDrdIndex = Math.max(0, Math.min(s.computed(s).getDrdIndex(), ((_b = nextDrds === null || nextDrds === void 0 ? void 0 : nextDrds.length) !== null && _b !== void 0 ? _b : 0) - 1));
        });
    }, [dmnEditorStoreApi]);
    return (_jsx(_Fragment, { children: _jsxs("div", __assign({ style: {
                display: "grid",
                gridTemplateColumns: "300px 300px",
                gridTemplateRows: "auto auto auto",
                gridTemplateAreas: "\n          'header-list header-properties'\n          'divider-list divider-properties'\n          'content-list content-properties'\n          ",
                columnGap: "40px",
            } }, { children: [_jsx("div", __assign({ style: { gridArea: "header-list" } }, { children: _jsxs("div", __assign({ style: { display: "flex", justifyContent: "space-between" } }, { children: [_jsx(TextContent, { children: _jsx(Text, __assign({ component: "h3" }, { children: "DRDs" })) }), _jsx(Button, __assign({ title: "New DRD", variant: ButtonVariant.link, onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        var _a, _b;
                                        var allDrds = (_b = (_a = state.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) !== null && _b !== void 0 ? _b : [];
                                        var newIndex = allDrds.length;
                                        addOrGetDrd({
                                            definitions: state.dmn.model.definitions,
                                            drdIndex: newIndex,
                                        });
                                        state.diagram.__unsafeDrdIndex = newIndex;
                                        state.diagram.openLhsPanel = DiagramLhsPanel.DRG_NODES;
                                        state.focus.consumableId = getDrdId({ drdIndex: newIndex });
                                    });
                                } }, { children: _jsx(PlusCircleIcon, {}) }))] })) })), _jsx("div", __assign({ style: { gridArea: "divider-list" } }, { children: _jsx(Divider, { style: { marginBottom: "8px" } }) })), (drds.length <= 0 && (_jsx(_Fragment, { children: _jsxs(EmptyState, { children: [_jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "You're on the default DRD" })), _jsx(EmptyStateBody, { children: "Adding nodes or making changes to the Diagram will automatically create a DRD for you." })] }) }))) || (_jsx("div", __assign({ style: { gridArea: "content-list" }, className: "kie-dmn-editor--drd-list" }, { children: drds.map(function (drd, i) { return (_jsxs(React.Fragment, { children: [_jsx("button", __assign({ className: i === drdIndex ? "active" : undefined, onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        state.diagram.__unsafeDrdIndex = i;
                                    });
                                } }, { children: "".concat(i + 1, ". ").concat(drd["@_name"] || getDefaultDrdName({ drdIndex: i })) })), _jsx("br", {})] }, drd["@_id"])); }) }))), _jsx("div", __assign({ style: { gridArea: "header-properties" } }, { children: _jsxs(Flex, __assign({ justifyContent: { default: "justifyContentSpaceBetween" } }, { children: [_jsx(Title, __assign({ headingLevel: "h3", style: { height: "36px" } }, { children: drdName })), drds.length > 0 && (_jsx(Button, __assign({ variant: ButtonVariant.link, onClick: removeDrd, style: { padding: 0 } }, { children: "Remove" })))] })) })), _jsx("div", __assign({ style: { gridArea: "divider-properties" } }, { children: _jsx(Divider, { style: { marginBottom: "8px" } }) })), _jsx("div", __assign({ style: { gridArea: "content-properties" } }, { children: _jsx(Form, { children: _jsx(FormSection, { children: _jsx(FormGroup, __assign({ label: "Input Data node shape" }, { children: _jsxs(ToggleGroup, __assign({ "aria-label": "Tweak the shape of the input data node", className: "kie-dmn-editor--drd-properties--input-data-node-shape" }, { children: [_jsx(ToggleGroupItem, { text: "Classic", icon: _jsx(InputDataIcon, { padding: "2px 0 0 0", height: 22 }), buttonId: "classic-input-node-shape", isSelected: isAlternativeInputDataShape === false, onChange: function () {
                                                return dmnEditorStoreApi.setState(function (s) {
                                                    var drd = addOrGetDrd({
                                                        definitions: s.dmn.model.definitions,
                                                        drdIndex: s.computed(s).getDrdIndex(),
                                                    }).diagram;
                                                    drd["@_useAlternativeInputDataShape"] = false;
                                                });
                                            } }), _jsx(ToggleGroupItem, { text: "Alternative", icon: _jsx(AlternativeInputDataIcon, { padding: "1px 0 0 0", height: 22, viewBox: 160, transform: "translate(40, 30)" }), buttonId: "alternative-input-node-shape", isSelected: isAlternativeInputDataShape === true, onChange: function () {
                                                return dmnEditorStoreApi.setState(function (s) {
                                                    var drd = addOrGetDrd({
                                                        definitions: s.dmn.model.definitions,
                                                        drdIndex: s.computed(s).getDrdIndex(),
                                                    }).diagram;
                                                    drd["@_useAlternativeInputDataShape"] = true;
                                                });
                                            } })] })) })) }) }) }))] })) }));
}
//# sourceMappingURL=DrdSelectorPanel.js.map