var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { AlternativeInputDataNodeSvg, BkmNodeSvg, DecisionNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, InputDataNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, } from "../diagram/nodes/NodeSvgs";
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { QuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/question-circle-icon";
var radius = 34;
var svgViewboxPadding = Math.sqrt(Math.pow(radius, 2) / 2) - radius / 2;
var nodeSvgProps = { width: 200, height: 120, x: 16, y: 48, strokeWidth: 16 };
export function RoundSvg(_a) {
    var children = _a.children, padding = _a.padding, height = _a.height, viewBox = _a.viewBox;
    var style = useMemo(function () { return (padding !== undefined ? { padding: padding, height: height } : { padding: "".concat(svgViewboxPadding, "px"), height: height }); }, [padding, height]);
    var nodeSvgViewboxSize = useMemo(function () {
        return viewBox !== null && viewBox !== void 0 ? viewBox : nodeSvgProps.width + 2 * nodeSvgProps.strokeWidth;
    }, [viewBox]);
    return (_jsx("svg", __assign({ className: "kie-dmn-editor--round-svg-container", viewBox: "0 0 ".concat(nodeSvgViewboxSize, " ").concat(nodeSvgViewboxSize), style: style }, { children: children })));
}
export function NodeIcon(_a) {
    var _b;
    var isAlternativeInputDataShape = _a.isAlternativeInputDataShape, nodeType = _a.nodeType;
    return switchExpression(nodeType, (_b = {},
        _b[NODE_TYPES.inputData] = isAlternativeInputDataShape ? AlternativeInputDataIcon : InputDataIcon,
        _b[NODE_TYPES.decision] = DecisionIcon,
        _b[NODE_TYPES.bkm] = BkmIcon,
        _b[NODE_TYPES.knowledgeSource] = KnowledgeSourceIcon,
        _b[NODE_TYPES.decisionService] = DecisionServiceIcon,
        _b[NODE_TYPES.group] = GroupIcon,
        _b[NODE_TYPES.textAnnotation] = TextAnnotationIcon,
        _b[NODE_TYPES.unknown] = UnknownIcon,
        _b.default = function () { return _jsx("div", { children: "?" }); },
        _b));
}
export function InputDataIcon(props) {
    return (_jsx(RoundSvg, __assign({ padding: props.padding, height: props.height }, { children: _jsx(InputDataNodeSvg, __assign({}, nodeSvgProps, { isCollection: false })) })));
}
export function AlternativeInputDataIcon(props) {
    var _a, _b;
    return (_jsx(RoundSvg, __assign({ padding: (_a = props.padding) !== null && _a !== void 0 ? _a : "0px", height: props.height, viewBox: props.viewBox }, { children: _jsx(AlternativeInputDataNodeSvg, __assign({}, nodeSvgProps, { isIcon: true, width: 80, height: 100, strokeWidth: 10, transform: (_b = props.transform) !== null && _b !== void 0 ? _b : "translate(80, 60)", isCollection: false })) })));
}
export function DecisionIcon() {
    return (_jsx(RoundSvg, { children: _jsx(DecisionNodeSvg, __assign({}, nodeSvgProps, { hasHiddenRequirements: false, isCollection: false })) }));
}
export function BkmIcon() {
    return (_jsx(RoundSvg, { children: _jsx(BkmNodeSvg, __assign({}, nodeSvgProps, { hasHiddenRequirements: false })) }));
}
export function KnowledgeSourceIcon() {
    return (_jsx(RoundSvg, { children: _jsx(KnowledgeSourceNodeSvg, __assign({}, nodeSvgProps, { hasHiddenRequirements: false })) }));
}
export function DecisionServiceIcon() {
    return (_jsx(RoundSvg, { children: _jsx(DecisionServiceNodeSvg, __assign({}, nodeSvgProps, { y: 12, height: nodeSvgProps.width, showSectionLabels: false, isReadonly: true })) }));
}
export function GroupIcon() {
    return (_jsx(RoundSvg, { children: _jsx(GroupNodeSvg, __assign({}, nodeSvgProps, { y: 12, height: nodeSvgProps.width, strokeDasharray: "28,28" })) }));
}
export function TextAnnotationIcon() {
    return (_jsx(RoundSvg, { children: _jsx(TextAnnotationNodeSvg, __assign({}, nodeSvgProps, { showPlaceholder: true })) }));
}
export function UnknownIcon() {
    return (_jsx("div", __assign({ style: { display: "flex", alignItems: "center", justifyContent: "center", height: "100%" } }, { children: _jsx(QuestionCircleIcon, {}) })));
}
//# sourceMappingURL=Icons.js.map