import React from "react";
import Moment from "react-moment";
export const getDashboardNameColumn = (selectDashboard) => {
    return {
        label: "Name",
        path: "name",
        bodyCellTransformer: (cellValue, rowDashboard) => {
            return (React.createElement("a", { onClick: () => selectDashboard(rowDashboard) },
                React.createElement("strong", null, cellValue)));
        },
        isSortable: true,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => React.createElement(Moment, { fromNow: true }, new Date(`${value}`)),
        isSortable: true,
    };
};
//# sourceMappingURL=CustomDashboardListUtils.js.map