import React, { useImperativeHandle, useState } from "react";
import FormDetails from "./components/FormDetails/FormDetails";
import FormDetailsEnvelopeViewDriver from "./FormDetailsEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
import FormDetailsContextProvider from "./components/contexts/FormDetailsContextProvider";
export const FormDetailsEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [formData, setFormData] = useState({});
    useImperativeHandle(forwardedRef, () => ({
        initialize: (form) => {
            setFormData(form);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(FormDetailsContextProvider, null,
            React.createElement(FormDetails, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new FormDetailsEnvelopeViewDriver(props.channelApi), formData: formData, targetOrigin: props.targetOrigin }))));
});
export default FormDetailsEnvelopeView;
//# sourceMappingURL=FormDetailsEnvelopeView.js.map