import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import React from "react";
import ReactJson from "@microlink/react-json-view";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import "../styles.css";
const WorkflowVariables = ({ displayLabel, displaySuccess, ouiaId, ouiaSafe, setDisplayLabel, setUpdateJson, updateJson, workflowInstance, }) => {
    const handleVariablesChange = (e) => {
        setUpdateJson({ ...updateJson, ...e.updated_src });
        setDisplayLabel(true);
    };
    const checkWorkflowStatus = workflowInstance.state === WorkflowInstanceState.Completed ||
        workflowInstance.state === WorkflowInstanceState.Aborted
        ? false
        : handleVariablesChange;
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "workflow-variables", ouiaSafe), children: [_jsxs(CardHeader, { children: [_jsx(Title, { headingLevel: "h3", size: "xl", children: "Variables" }), displayLabel && (_jsxs(Label, { color: "orange", icon: _jsx(InfoCircleIcon, {}), children: [" ", "Changes are not saved yet"] })), _jsxs(Label, { color: "green", icon: _jsx(InfoCircleIcon, {}), className: displaySuccess
                            ? "kogito-workflow-details--variables__label-fadeIn"
                            : "kogito-workflow-details--variables__label-fadeOut", children: [" ", "Changes are saved"] })] }), _jsx(CardBody, { children: _jsx(TextContent, { children: _jsx("div", { children: _jsx(ReactJson, { src: updateJson, name: false, onEdit: checkWorkflowStatus, onAdd: checkWorkflowStatus, onDelete: checkWorkflowStatus }) }) }) })] }));
};
export default React.memo(WorkflowVariables);
//# sourceMappingURL=WorkflowVariables.js.map