import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildXmlHref, parseXmlHref, xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml";
import { getAutoLayoutedInfo } from "../autolayout/autoLayoutInfo";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
import { computeDiagramData } from "../store/computed/computeDiagramData";
import { computeDirectlyIncludedExternalModelsByNamespace } from "../store/computed/computeDirectlyIncludedExternalModelsByNamespace";
import { computeIndexedDrd } from "../store/computed/computeIndexes";
import { addOrGetDrd } from "./addOrGetDrd";
import { addShape } from "./addShape";
import { applyAutoLayoutToDrd } from "./applyAutoLayoutToDrd";
import { repositionNode } from "./repositionNode";
export var StrategyForAddingDecisionServiceToDrd;
(function (StrategyForAddingDecisionServiceToDrd) {
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["AUTO_GENERATE"] = 0] = "AUTO_GENERATE";
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["CONFLICT"] = 1] = "CONFLICT";
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["COPY_FROM_ANOTHER_DRD"] = 2] = "COPY_FROM_ANOTHER_DRD";
})(StrategyForAddingDecisionServiceToDrd || (StrategyForAddingDecisionServiceToDrd = {}));
export function getStrategyToAddExistingDecisionServiceToDrd({ __readonly_definitions, __readonly_decisionServiceNamespace, __readonly_drgElement, __readonly_externalDmnsIndex, __readonly_namespace, __readonly_indexedDrd, __readonly_drdIndex, }) {
    var _a, _b, _c, _d;
    const decisionServiceDmnDefinitions = !__readonly_decisionServiceNamespace || __readonly_decisionServiceNamespace === __readonly_namespace
        ? __readonly_definitions
        : (_a = __readonly_externalDmnsIndex.get(__readonly_decisionServiceNamespace)) === null || _a === void 0 ? void 0 : _a.model.definitions;
    if (!decisionServiceDmnDefinitions) {
        throw new Error(`DMN MUTATION: Can't find definitions for model with namespace ${__readonly_decisionServiceNamespace}`);
    }
    const { decisionServiceNamespaceForHref, containedDecisionHrefsRelativeToThisDmn } = getDecisionServicePropertiesRelativeToThisDmn({
        thisDmnsNamespace: __readonly_namespace,
        decisionServiceNamespace: __readonly_decisionServiceNamespace,
        decisionService: __readonly_drgElement,
    });
    const decisionServiceHrefRelativeToThisDmn = buildXmlHref({
        namespace: decisionServiceNamespaceForHref,
        id: __readonly_drgElement["@_id"],
    });
    const drgElementsByNamespace = new Map([[__readonly_namespace, __readonly_definitions.drgElement]]);
    __readonly_externalDmnsIndex.forEach((value, key) => {
        drgElementsByNamespace.set(key, value.model.definitions.drgElement);
    });
    const containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = computeContainingDecisionServiceHrefsByDecisionHrefs({
        thisDmnsNamespace: __readonly_namespace,
        drgElementsByNamespace,
    });
    const doesThisDrdHaveConflictingDecisionService = containedDecisionHrefsRelativeToThisDmn.some((decisionHref) => {
        var _a;
        return ((_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(decisionHref)) !== null && _a !== void 0 ? _a : []).some((d) => __readonly_indexedDrd.dmnShapesByHref.has(d));
    });
    if (doesThisDrdHaveConflictingDecisionService) {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.CONFLICT,
            decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn,
        };
    }
    const drds = (_c = (_b = decisionServiceDmnDefinitions["dmndi:DMNDI"]) === null || _b === void 0 ? void 0 : _b["dmndi:DMNDiagram"]) !== null && _c !== void 0 ? _c : [];
    let indexedDrd;
    for (let i = 0; i < drds.length; i++) {
        if (__readonly_namespace === __readonly_decisionServiceNamespace && i === __readonly_drdIndex) {
            continue;
        }
        const _indexedDrd = computeIndexedDrd(__readonly_namespace, decisionServiceDmnDefinitions, i);
        const dsShape = _indexedDrd.dmnShapesByHref.get(decisionServiceHrefRelativeToThisDmn);
        const hasCompleteExpandedDepictionOfDecisionService = dsShape &&
            !((_d = dsShape["@_isCollapsed"]) !== null && _d !== void 0 ? _d : false) &&
            containedDecisionHrefsRelativeToThisDmn.every((dHref) => _indexedDrd.dmnShapesByHref.has(dHref));
        if (hasCompleteExpandedDepictionOfDecisionService) {
            indexedDrd = _indexedDrd;
            break;
        }
    }
    if (indexedDrd === undefined) {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE,
            decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn,
        };
    }
    else {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD,
            indexedDrdContainingDecisionServiceDepiction: indexedDrd,
            decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn,
        };
    }
}
export function addConflictingDecisionServiceToDrd({ definitions, __readonly_drdIndex, __readonly_dropPoint, __readonly_decisionServiceHrefRelativeToThisDmn, }) {
    addShape({
        definitions: definitions,
        drdIndex: __readonly_drdIndex,
        nodeType: NODE_TYPES.decisionService,
        shape: {
            "@_id": generateUuid(),
            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, definitions),
            "@_isCollapsed": true,
            "dc:Bounds": {
                "@_x": __readonly_dropPoint.x,
                "@_y": __readonly_dropPoint.y,
                "@_width": DECISION_SERVICE_COLLAPSED_DIMENSIONS.width,
                "@_height": DECISION_SERVICE_COLLAPSED_DIMENSIONS.height,
            },
        },
    });
}
export async function addAutoGeneratedDecisionServiceToDrd({ state, __readonly_decisionServiceNamespace, __readonly_externalDmnsIndex, __readonly_drdIndex, __readonly_snapGrid, __readonly_decisionServiceHrefRelativeToThisDmn, __readonly_containedDecisionHrefsRelativeToThisDmn, __readonly_dropPoint, __readonly_isAlternativeInputDataShape, __readonly_externalModelsByNamespace, }) {
    var _a, _b, _c, _d, _e, _f, _g;
    var _h;
    const drds = (_a = state.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"];
    const dummyDrdIndex = (drds === null || drds === void 0 ? void 0 : drds.length) === undefined ? 0 : drds.length;
    addOrGetDrd({
        definitions: state.dmn.model.definitions,
        drdIndex: dummyDrdIndex,
    });
    const minNodeSize = MIN_NODE_SIZES[NODE_TYPES.decisionService]({
        snapGrid: __readonly_snapGrid,
    });
    addShape({
        definitions: state.dmn.model.definitions,
        drdIndex: dummyDrdIndex,
        nodeType: NODE_TYPES.decisionService,
        shape: {
            "@_id": generateUuid(),
            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, state.dmn.model.definitions),
            "dc:Bounds": {
                "@_x": 0,
                "@_y": 0,
                ...minNodeSize,
            },
        },
    });
    for (const decisionHref of __readonly_containedDecisionHrefsRelativeToThisDmn) {
        const decisionNs = parseXmlHref(decisionHref).namespace;
        const decisionDmnDefinitions = !decisionNs || decisionNs === state.dmn.model.definitions["@_namespace"]
            ? state.dmn.model.definitions
            : (_b = __readonly_externalDmnsIndex.get(decisionNs)) === null || _b === void 0 ? void 0 : _b.model.definitions;
        if (!decisionDmnDefinitions) {
            throw new Error(`DMN MUTATION: Can't find definitions for model with namespace ${__readonly_decisionServiceNamespace}`);
        }
        const minNodeSize = MIN_NODE_SIZES[NODE_TYPES.decision]({
            snapGrid: __readonly_snapGrid,
        });
        addShape({
            definitions: state.dmn.model.definitions,
            drdIndex: dummyDrdIndex,
            nodeType: NODE_TYPES.decision,
            shape: {
                "@_id": generateUuid(),
                "@_dmnElementRef": xmlHrefToQName(decisionHref, state.dmn.model.definitions),
                "dc:Bounds": {
                    "@_x": 0,
                    "@_y": 0,
                    ...minNodeSize,
                },
            },
        });
    }
    const externalModelTypesByNamespace = computeDirectlyIncludedExternalModelsByNamespace(state.dmn.model.definitions.import, __readonly_externalModelsByNamespace);
    const dummyIndexedDrd = computeIndexedDrd(state.dmn.model.definitions["@_namespace"], state.dmn.model.definitions, dummyDrdIndex);
    const { nodes, nodesById, edges, edgesById, drgEdges } = computeDiagramData(state.diagram, state.dmn.model.definitions, externalModelTypesByNamespace, dummyIndexedDrd, __readonly_isAlternativeInputDataShape);
    const { __readonly_autoLayoutedInfo, __readonly_parentNodesById } = await getAutoLayoutedInfo({
        __readonly_snapGrid,
        __readonly_nodesById: nodesById,
        __readonly_edgesById: edgesById,
        __readonly_nodes: nodes,
        __readonly_drgEdges: drgEdges,
        __readonly_isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
    });
    applyAutoLayoutToDrd({
        state,
        __readonly_dmnShapesByHref: dummyIndexedDrd.dmnShapesByHref,
        __readonly_edges: edges,
        __readonly_edgesById: edgesById,
        __readonly_nodesById: nodesById,
        __readonly_autoLayoutedInfo,
        __readonly_parentNodesById,
        __readonly_drdIndex: dummyDrdIndex,
        __readonly_dmnObjectNamespace: __readonly_decisionServiceNamespace,
        __readonly_externalDmnsIndex: externalModelTypesByNamespace.dmns,
        __readonly_externalModelsByNamespace,
    });
    const { "@_x": dsShapeX, "@_y": dsShapeY } = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn)["dc:Bounds"];
    repositionNode({
        definitions: state.dmn.model.definitions,
        drdIndex: dummyDrdIndex,
        controlWaypointsByEdge: new Map(),
        change: {
            nodeType: NODE_TYPES.decisionService,
            type: "absolute",
            position: { x: __readonly_dropPoint.x, y: __readonly_dropPoint.y },
            shapeIndex: (_d = (_c = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn)) === null || _c === void 0 ? void 0 : _c.index) !== null && _d !== void 0 ? _d : 0,
            selectedEdges: [],
            sourceEdgeIndexes: [],
            targetEdgeIndexes: [],
        },
    });
    for (const decisionHref of __readonly_containedDecisionHrefsRelativeToThisDmn) {
        const currentDecisionShape = dummyIndexedDrd.dmnShapesByHref.get(decisionHref);
        const x = __readonly_dropPoint.x + currentDecisionShape["dc:Bounds"]["@_x"] - dsShapeX;
        const y = __readonly_dropPoint.y + currentDecisionShape["dc:Bounds"]["@_y"] - dsShapeY;
        if (currentDecisionShape) {
            repositionNode({
                definitions: state.dmn.model.definitions,
                drdIndex: dummyDrdIndex,
                controlWaypointsByEdge: new Map(),
                change: {
                    nodeType: NODE_TYPES.decision,
                    type: "absolute",
                    position: { x, y },
                    shapeIndex: currentDecisionShape.index,
                    selectedEdges: [],
                    sourceEdgeIndexes: [],
                    targetEdgeIndexes: [],
                },
            });
        }
    }
    if (dummyDrdIndex !== __readonly_drdIndex) {
        const { index, dmnElementRefQName, ...dsShape } = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn);
        (_e = (_h = drds[__readonly_drdIndex])["dmndi:DMNDiagramElement"]) !== null && _e !== void 0 ? _e : (_h["dmndi:DMNDiagramElement"] = []);
        (_f = drds === null || drds === void 0 ? void 0 : drds[__readonly_drdIndex]["dmndi:DMNDiagramElement"]) === null || _f === void 0 ? void 0 : _f.push({ ...dsShape, __$$element: "dmndi:DMNShape" });
        for (const decisionHref of __readonly_containedDecisionHrefsRelativeToThisDmn) {
            const { index, dmnElementRefQName, ...decisionShape } = dummyIndexedDrd.dmnShapesByHref.get(decisionHref);
            (_g = drds === null || drds === void 0 ? void 0 : drds[__readonly_drdIndex]["dmndi:DMNDiagramElement"]) === null || _g === void 0 ? void 0 : _g.push({
                ...decisionShape,
                __$$element: "dmndi:DMNShape",
            });
        }
        drds === null || drds === void 0 ? void 0 : drds.pop();
    }
    else {
    }
}
export function addExistingDecisionServiceToDrd({ definitions, __readonly_decisionServiceNamespace, __readonly_externalDmnsIndex, __readonly_namespace, __readonly_indexedDrd, __readonly_indexedDrdContainingDecisionServiceDepiction, __readonly_drdIndex, __readonly_dropPoint, __readonly_decisionServiceHrefRelativeToThisDmn, __readonly_containedDecisionHrefsRelativeToThisDmn, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
    const dsShapeOnOtherDrd = __readonly_indexedDrdContainingDecisionServiceDepiction.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn);
    if (((_a = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _a === void 0 ? void 0 : _a["@_x"]) === undefined ||
        ((_b = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _b === void 0 ? void 0 : _b["@_y"]) === undefined) {
        throw new Error(`DMN MUTATION: Complete DMNShape for Decision Service with href ${__readonly_decisionServiceHrefRelativeToThisDmn} should've existed on the indexed DRD.`);
    }
    const dsDividirLineOnOtherDrd = dsShapeOnOtherDrd["dmndi:DMNDecisionServiceDividerLine"];
    const decisionServiceDividerLineWaypoint = [
        {
            "@_x": __readonly_dropPoint.x,
            "@_y": ((_d = (_c = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _c === void 0 ? void 0 : _c[0]["@_y"]) !== null && _d !== void 0 ? _d : 0) -
                ((_f = (_e = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _e === void 0 ? void 0 : _e["@_y"]) !== null && _f !== void 0 ? _f : 0) +
                __readonly_dropPoint.y,
        },
        {
            "@_x": ((_h = (_g = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _g === void 0 ? void 0 : _g[1]["@_x"]) !== null && _h !== void 0 ? _h : 0) -
                ((_k = (_j = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _j === void 0 ? void 0 : _j[0]["@_x"]) !== null && _k !== void 0 ? _k : 0) +
                __readonly_dropPoint.x,
            "@_y": ((_m = (_l = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _l === void 0 ? void 0 : _l[0]["@_y"]) !== null && _m !== void 0 ? _m : 0) -
                ((_p = (_o = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _o === void 0 ? void 0 : _o["@_y"]) !== null && _p !== void 0 ? _p : 0) +
                __readonly_dropPoint.y,
        },
    ];
    addShape({
        definitions: definitions,
        drdIndex: __readonly_drdIndex,
        nodeType: NODE_TYPES.decisionService,
        shape: {
            "@_id": generateUuid(),
            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, definitions),
            "dc:Bounds": {
                "@_x": __readonly_dropPoint.x,
                "@_y": __readonly_dropPoint.y,
                "@_width": dsShapeOnOtherDrd["dc:Bounds"]["@_width"],
                "@_height": dsShapeOnOtherDrd["dc:Bounds"]["@_height"],
            },
        },
        decisionServiceDividerLineWaypoint,
    });
    for (const decisionHref of __readonly_containedDecisionHrefsRelativeToThisDmn) {
        const decisionShapeOnOtherDrd = __readonly_indexedDrdContainingDecisionServiceDepiction.dmnShapesByHref.get(decisionHref);
        if (((_q = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _q === void 0 ? void 0 : _q["@_x"]) === undefined ||
            ((_r = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _r === void 0 ? void 0 : _r["@_y"]) === undefined ||
            ((_s = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _s === void 0 ? void 0 : _s["@_width"]) === undefined ||
            ((_t = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _t === void 0 ? void 0 : _t["@_height"]) === undefined) {
            throw new Error(`DMN MUTATION: Complete DMNShape for Decision with href ${decisionHref} should've existed on the indexed DRD.`);
        }
        const x = __readonly_dropPoint.x + (decisionShapeOnOtherDrd["dc:Bounds"]["@_x"] - dsShapeOnOtherDrd["dc:Bounds"]["@_x"]);
        const y = __readonly_dropPoint.y + (decisionShapeOnOtherDrd["dc:Bounds"]["@_y"] - dsShapeOnOtherDrd["dc:Bounds"]["@_y"]);
        const existingDecisionShape = __readonly_indexedDrd.dmnShapesByHref.get(decisionHref);
        if (existingDecisionShape) {
            repositionNode({
                definitions: definitions,
                drdIndex: __readonly_drdIndex,
                controlWaypointsByEdge: new Map(),
                change: {
                    nodeType: NODE_TYPES.decision,
                    type: "absolute",
                    position: { x, y },
                    shapeIndex: existingDecisionShape.index,
                    selectedEdges: [],
                    sourceEdgeIndexes: [],
                    targetEdgeIndexes: [],
                },
            });
        }
        else {
            const decisionNs = parseXmlHref(decisionHref).namespace;
            const decisionDmnDefinitions = !decisionNs || decisionNs === __readonly_namespace
                ? definitions
                : (_u = __readonly_externalDmnsIndex.get(decisionNs)) === null || _u === void 0 ? void 0 : _u.model.definitions;
            if (!decisionDmnDefinitions) {
                throw new Error(`DMN MUTATION: Can't find definitions for model with namespace ${__readonly_decisionServiceNamespace}`);
            }
            addShape({
                definitions: definitions,
                drdIndex: __readonly_drdIndex,
                nodeType: NODE_TYPES.decision,
                shape: {
                    "@_id": generateUuid(),
                    "@_dmnElementRef": xmlHrefToQName(decisionHref, definitions),
                    "dc:Bounds": {
                        "@_x": x,
                        "@_y": y,
                        "@_width": decisionShapeOnOtherDrd["dc:Bounds"]["@_width"],
                        "@_height": decisionShapeOnOtherDrd["dc:Bounds"]["@_height"],
                    },
                },
            });
        }
    }
}
export function getDecisionServicePropertiesRelativeToThisDmn({ thisDmnsNamespace, decisionServiceNamespace, decisionService, }) {
    var _a, _b;
    const decisionServiceNamespaceForHref = decisionServiceNamespace === thisDmnsNamespace ? "" : decisionServiceNamespace;
    const containedDecisionHrefsRelativeToThisDmn = [
        ...((_a = decisionService.outputDecision) !== null && _a !== void 0 ? _a : []),
        ...((_b = decisionService.encapsulatedDecision) !== null && _b !== void 0 ? _b : []),
    ].map((d) => {
        const parsedHref = parseXmlHref(d["@_href"]);
        return buildXmlHref({
            namespace: !parsedHref.namespace ? decisionServiceNamespaceForHref : parsedHref.namespace,
            id: parsedHref.id,
        });
    });
    return { decisionServiceNamespaceForHref, containedDecisionHrefsRelativeToThisDmn };
}
//# sourceMappingURL=addExistingDecisionServiceToDrd.js.map