import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function addImport({ definitions, includedModel, }) {
    var _a;
    const isAlreadyUsingExplicitRelativePathNotation = includedModel.normalizedPathRelativeToThisDmn.startsWith("./") ||
        includedModel.normalizedPathRelativeToThisDmn.startsWith("../");
    const posixPathExplicitlyRelativeToThisDmn = isAlreadyUsingExplicitRelativePathNotation
        ? includedModel.normalizedPathRelativeToThisDmn
        : `./${includedModel.normalizedPathRelativeToThisDmn}`;
    const newImport = {
        "@_id": generateUuid(),
        "@_name": includedModel.name.trim(),
        "@_importType": includedModel.xmlns,
        "@_namespace": includedModel.namespace,
        "@_locationURI": posixPathExplicitlyRelativeToThisDmn,
    };
    (_a = definitions.import) !== null && _a !== void 0 ? _a : (definitions.import = []);
    definitions.import.push(newImport);
    let index = 0;
    while (definitions[`@_xmlns:included${index}`]) {
        index++;
    }
    definitions[`@_xmlns:included${index}`] = includedModel.namespace;
    return newImport;
}
//# sourceMappingURL=addImport.js.map