import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Slider } from "@patternfly/react-core/dist/js/components/Slider";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useLayoutEffect, useRef } from "react";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { useSettings } from "../settings/DmnEditorSettingsContext";
const MIN_SNAP = 5;
const MAX_SNAP = 50;
const SNAP_STEP = 5;
const BOTTOM_MARGIN = 10;
export function OverlaysPanel({ availableHeight }) {
    const diagram = useDmnEditorStore((s) => s.diagram);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const overlayPanelContainer = useRef(null);
    const { isEvaluationHighlightsSupported } = useSettings();
    useLayoutEffect(() => {
        if (overlayPanelContainer.current && availableHeight) {
            if (overlayPanelContainer.current.scrollHeight <= availableHeight) {
                overlayPanelContainer.current.style.overflowY = "hidden";
                overlayPanelContainer.current.style.height = "auto";
            }
            else if (overlayPanelContainer.current.style.height !== availableHeight - BOTTOM_MARGIN + "px" &&
                overlayPanelContainer.current.style.height !== "auto") {
                overlayPanelContainer.current.style.height = availableHeight - BOTTOM_MARGIN + "px";
                overlayPanelContainer.current.style.overflowY = "auto";
            }
        }
    }, [availableHeight]);
    return (_jsxs("div", { ref: overlayPanelContainer, children: [_jsxs(Form, { onKeyDown: (e) => e.stopPropagation(), children: [_jsx(FormGroup, { label: "Snapping", children: _jsx(Switch, { "aria-label": "Snapping", isChecked: diagram.snapGrid.isEnabled, onChange: (newValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.snapGrid.isEnabled = newValue;
                            }) }) }), _jsx(FormGroup, { label: "Horizontal", children: _jsx(Slider, { "data-testid": "kie-tools--dmn-editor--horizontal-snapping-control", className: "kie-dmn-editor--snap-slider", isDisabled: !diagram.snapGrid.isEnabled, value: diagram.snapGrid.x, min: MIN_SNAP, max: MAX_SNAP, isInputVisible: true, inputValue: diagram.snapGrid.x, step: SNAP_STEP, showTicks: true, hasTooltipOverThumb: true, onChange: (newSliderValue, newInputValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.snapGrid.x = Math.min(MAX_SNAP, Math.max(MIN_SNAP, newInputValue !== null && newInputValue !== void 0 ? newInputValue : newSliderValue));
                            }) }) }), _jsx(FormGroup, { label: "Vertical", children: _jsx(Slider, { "data-testid": "kie-tools--dmn-editor--vertical-snapping-control", className: "kie-dmn-editor--snap-slider", isDisabled: !diagram.snapGrid.isEnabled, value: diagram.snapGrid.y, min: MIN_SNAP, max: MAX_SNAP, isInputVisible: true, inputValue: diagram.snapGrid.y, step: SNAP_STEP, showTicks: true, hasTooltipOverThumb: true, onChange: (newSliderValue, newInputValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.snapGrid.y = Math.min(MAX_SNAP, Math.max(MIN_SNAP, newInputValue !== null && newInputValue !== void 0 ? newInputValue : newSliderValue));
                            }) }) })] }), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsxs(Form, { onKeyDown: (e) => e.stopPropagation(), children: [_jsx(FormGroup, { label: "Highlight selected node(s) hierarchy", children: _jsx(Switch, { "aria-label": "Highlight selected node(s) hierarchy", isChecked: diagram.overlays.enableNodeHierarchyHighlight, onChange: (newValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.overlays.enableNodeHierarchyHighlight = newValue;
                            }) }) }), _jsx(FormGroup, { label: "Show data type toolbar on nodes", children: _jsx(Switch, { "aria-label": "Show data type toolbar on nodes", isChecked: diagram.overlays.enableDataTypesToolbarOnNodes, onChange: (newValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.overlays.enableDataTypesToolbarOnNodes = newValue;
                            }) }) }), _jsx(FormGroup, { label: "Enable styles", children: _jsx(Switch, { "aria-label": "Show data type toolbar on nodes", isChecked: diagram.overlays.enableCustomNodeStyles, onChange: (newValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.overlays.enableCustomNodeStyles = newValue;
                            }) }) }), isEvaluationHighlightsSupported && (_jsx(FormGroup, { label: "Enable evaluation highlights", labelIcon: _jsx(Tooltip, { content: "Enable highlighting Decision Table rules and Boxed Conditional Expression branches based on evaluation results, also showing success/error status badges on Decision nodes.", children: _jsx(Icon, { size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) }), children: _jsx(Switch, { "data-testid": "kie-tools--dmn-editor--evaluation-highlights-control", isChecked: diagram.overlays.enableEvaluationHighlights, onChange: (newValue) => dmnEditorStoreApi.setState((state) => {
                                state.diagram.overlays.enableEvaluationHighlights = newValue;
                            }) }) }))] })] }));
}
//# sourceMappingURL=OverlaysPanel.js.map