import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { DrawerHead, DrawerPanelContent } from "@patternfly/react-core/dist/js/components/Drawer";
import { GlobalDiagramProperties } from "./GlobalDiagramProperties";
import { SingleNodeProperties } from "./SingleNodeProperties";
import { MultipleNodeProperties } from "./MultipleNodeProperties";
import { useDmnEditorStore } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import "./DiagramPropertiesPanel.css";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
export function DiagramPropertiesPanel() {
    const { externalModelsByNamespace } = useExternalModels();
    const selectedNodesById = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById);
    return (_jsx(DrawerPanelContent, { "data-testid": "kie-tools--dmn-editor--properties-panel-container", isResizable: true, minSize: "300px", defaultSize: "500px", onKeyDown: (e) => {
            if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
                e.stopPropagation();
            }
        }, children: _jsxs(DrawerHead, { children: [selectedNodesById.size <= 0 && _jsx(GlobalDiagramProperties, {}), selectedNodesById.size === 1 && _jsx(SingleNodeProperties, { nodeId: [...selectedNodesById.keys()][0] }), selectedNodesById.size > 1 && _jsx(MultipleNodeProperties, { nodeIds: [...selectedNodesById.keys()] })] }) }));
}
//# sourceMappingURL=DiagramPropertiesPanel.js.map