import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import "./ModelTitle.scss";
import { ValidationLevel } from "../../../validation";
export const ValidationIndicator = (props) => {
    const { validations } = props;
    const maxLevel = useMemo(() => getMaxLevel(validations), [validations]);
    return (_jsx(_Fragment, { children: maxLevel !== undefined && (_jsx(ValidationIndicatorTooltip, { validations: validations, children: _jsxs(_Fragment, { children: [maxLevel === ValidationLevel.ERROR && _jsx(ExclamationCircleIcon, { size: "sm", color: "red" }), maxLevel === ValidationLevel.WARNING && _jsx(ExclamationTriangleIcon, { size: "sm", color: "orange" })] }) })) }));
};
export const ValidationIndicatorTooltip = (props) => {
    const { validations, children, customTooltipContent } = props;
    return (_jsx(_Fragment, { children: validations.length > 0 && (_jsx(Tooltip, { maxWidth: "100%", isContentLeftAligned: true, content: customTooltipContent ? customTooltipContent : list(validations), children: children })) }));
};
export const ValidationIndicatorLabel = (props) => {
    const { validations, children, customTooltipContent, onClose, cssClass } = props;
    const maxLevel = useMemo(() => getMaxLevel(validations), [validations]);
    const labelColor = useMemo(() => {
        switch (maxLevel) {
            case ValidationLevel.ERROR:
                return "red";
            case ValidationLevel.WARNING:
                return "orange";
            default:
                return "orange";
        }
    }, [maxLevel]);
    const labelIcon = useMemo(() => {
        switch (maxLevel) {
            case ValidationLevel.ERROR:
                return _jsx(ExclamationCircleIcon, { size: "sm", color: "red" });
            case ValidationLevel.WARNING:
                return _jsx(ExclamationTriangleIcon, { size: "sm", color: "orange" });
            default:
                return undefined;
        }
    }, [maxLevel]);
    return (_jsx(_Fragment, { children: maxLevel !== undefined && (_jsx(ValidationIndicatorTooltip, { validations: validations, customTooltipContent: customTooltipContent, children: _jsx(Label, { onClose: onClose, className: cssClass, color: labelColor, icon: labelIcon, "data-ouia-component-type": "invalid-label", children: children }) })) }));
};
const getMaxLevel = (validations) => {
    if (validations.length === 0) {
        return undefined;
    }
    return validations.reduce((pv, cv) => {
        if (pv.level < cv.level) {
            return cv;
        }
        if (pv.level > cv.level) {
            return pv;
        }
        return cv;
    }).level;
};
const list = (validations) => {
    return (_jsx("ol", { children: validations.map((validation, index) => (_jsx("li", { children: validation.message }, index))) }));
};
//# sourceMappingURL=ValidationIndicator.js.map