import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useMemo, useRef, useState } from "react";
export var ResizerStopBehavior;
(function (ResizerStopBehavior) {
    ResizerStopBehavior[ResizerStopBehavior["SET_WIDTH_WHEN_SMALLER"] = 0] = "SET_WIDTH_WHEN_SMALLER";
    ResizerStopBehavior[ResizerStopBehavior["SET_WIDTH_ALWAYS"] = 1] = "SET_WIDTH_ALWAYS";
})(ResizerStopBehavior || (ResizerStopBehavior = {}));
export const DEFAULT_RESIZING_WIDTH = {
    value: -2,
    isPivoting: false,
};
export function ResizingWidthsContextProvider({ children }) {
    const [resizingWidths, setResizingWidths] = useState(new Map());
    const value = useMemo(() => {
        return { resizingWidths };
    }, [resizingWidths]);
    const refs = useRef(new Set());
    const isResizingRef = useRef(false);
    const dispatch = useMemo(() => {
        return {
            setResizing: (isResizing) => {
                isResizingRef.current = isResizing;
            },
            isResizing: () => {
                return isResizingRef.current;
            },
            updateResizingWidth: (id, getNewResizingWidth) => {
                setResizingWidths((prev) => {
                    var _a;
                    const n = new Map(prev);
                    n.set(id, getNewResizingWidth((_a = n.get(id)) !== null && _a !== void 0 ? _a : DEFAULT_RESIZING_WIDTH));
                    return n;
                });
            },
            registerResizerRef: (ref) => {
                refs.current.add(ref);
                return ref;
            },
            deregisterResizerRef: (ref) => {
                refs.current.delete(ref);
            },
            getResizerRefs: () => {
                return refs.current;
            },
        };
    }, []);
    return (_jsx(ResizingWidthsContext.Provider, { value: value, children: _jsx(ResizingWidthsDispatchContext.Provider, { value: dispatch, children: _jsx(_Fragment, { children: children }) }) }));
}
const ResizingWidthsContext = React.createContext({});
const ResizingWidthsDispatchContext = React.createContext({});
export function useResizingWidths() {
    return React.useContext(ResizingWidthsContext);
}
export function useResizingWidthsDispatch() {
    return React.useContext(ResizingWidthsDispatchContext);
}
export function useResizerRef(resizerRef) {
    const { registerResizerRef, deregisterResizerRef } = useResizingWidthsDispatch();
    useEffect(() => {
        const ref = registerResizerRef(resizerRef);
        return () => {
            deregisterResizerRef(ref);
        };
    }, [deregisterResizerRef, registerResizerRef, resizerRef]);
}
//# sourceMappingURL=ResizingWidthsContext.js.map