import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useRef } from "react";
import { Resizer } from "../../resizing/Resizer";
import { useBeeTableResizableCell } from "../../resizing/BeeTableResizableColumnsContext";
import { useBeeTableSelectableCell } from "../../selection/BeeTableSelectionContext";
export function BeeTableTdForAdditionalRow({ children, isEmptyCell, columnIndex, column, rowIndex, isLastColumn, resizerStopBehavior, lastColumnMinWidth, isReadOnly, }) {
    var _a, _b;
    const tdRef = useRef(null);
    const { resizingWidth, setResizingWidth } = useBeeTableResizableCell(columnIndex, resizerStopBehavior, column.width, column.setWidth, column.width ? Math.max((_a = lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : column.minWidth) !== null && _a !== void 0 ? _a : 0, (_b = column.width) !== null && _b !== void 0 ? _b : 0) : undefined);
    const { cssClasses, onMouseDown, onDoubleClick } = useBeeTableSelectableCell(tdRef, rowIndex, columnIndex);
    return isEmptyCell ? (_jsx("td", { ref: tdRef, role: "cell", className: `empty-cell ${cssClasses}`, onMouseDown: onMouseDown, onDoubleClick: onDoubleClick, children: _jsx("br", {}) })) : (_jsxs("td", { ref: tdRef, role: "cell", className: `additional-row-content ${cssClasses}`, tabIndex: -1, onMouseDown: onMouseDown, onDoubleClick: onDoubleClick, children: [children, !column.isWidthConstant && !isReadOnly && (_jsx(Resizer, { minWidth: lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : column.minWidth, width: column.width, setWidth: column.setWidth, resizingWidth: resizingWidth, setResizingWidth: setResizingWidth }))] }));
}
//# sourceMappingURL=BeeTableTdForAdditionalRow.js.map