import { jsx as _jsx } from "react/jsx-runtime";
import Moment from "react-moment";
export const getDashboardNameColumn = (selectDashboard) => {
    return {
        label: "Name",
        path: "name",
        bodyCellTransformer: (cellValue, rowDashboard) => {
            return (_jsx("a", { onClick: () => selectDashboard(rowDashboard), children: _jsx("strong", { children: cellValue }) }));
        },
        isSortable: true,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => _jsx(Moment, { fromNow: true, children: new Date(`${value}`) }),
        isSortable: true,
    };
};
//# sourceMappingURL=CustomDashboardListUtils.js.map