import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { AboutModal } from "@patternfly/react-core/dist/js/components/AboutModal";
import { TextContent, Text, TextList, TextListItem } from "@patternfly/react-core/dist/js/components/Text";
import "../styles.css";
import aboutPageBackground from "../../static/kogitoAbout.png";
import { componentOuiaProps } from "../../ouiaTools";
import { useBrandContext } from "../../contexts/BrandContext/BrandContext";
const AboutModalBox = ({ isOpenProp, handleModalToggleProp, ouiaId, ouiaSafe }) => {
    const dataIndexURL = window.DATA_INDEX_ENDPOINT || process.env.KOGITO_DATAINDEX_HTTP_URL;
    const appName = window.KOGITO_APP_NAME || process.env.KOGITO_APP_NAME;
    const appVersion = window.KOGITO_APP_VERSION || process.env.KOGITO_APP_VERSION;
    const brandContext = useBrandContext();
    return (_jsx(AboutModal, { isOpen: isOpenProp, onClose: handleModalToggleProp, trademark: `${appName} is part of Kogito, an open source software released under the Apache Software License 2.0`, brandImageSrc: brandContext.imageSrc, brandImageAlt: brandContext.altText, className: "kogito-consoles-common--aboutModalBox", backgroundImageSrc: aboutPageBackground, ...componentOuiaProps(ouiaId, "AboutModalBox", ouiaSafe), children: _jsxs(TextContent, { children: [_jsx(Text, { component: "h5" }), _jsxs(TextList, { component: "dl", children: [_jsx(TextListItem, { component: "dt", children: "Version: " }), _jsx(TextListItem, { component: "dd", children: appVersion }), _jsx(TextListItem, { component: "dt", children: "License information: " }), _jsx(TextListItem, { component: "dd", children: _jsx("a", { href: "https://github.com/apache/incubator-kie-kogito-runtimes/blob/main/LICENSE", target: "_blank", rel: "noreferrer", children: "https://github.com/apache/incubator-kie-kogito-runtimes/blob/main/LICENSE" }) }), _jsx(TextListItem, { component: "dt", children: "Report a bug: " }), _jsx(TextListItem, { component: "dd", children: _jsx("a", { href: "https://issues.redhat.com/projects/KOGITO", target: "_blank", rel: "noreferrer", children: "https://issues.redhat.com/projects/KOGITO" }) }), _jsx(TextListItem, { component: "dt", children: "Get involved/help/docs: " }), _jsx(TextListItem, { component: "dd", children: _jsx("a", { href: "https://docs.jboss.org/kogito/release/latest/html_single/", target: "_blank", rel: "noreferrer", children: "https://docs.jboss.org/kogito/release/latest/html_single/" }) }), _jsx(TextListItem, { component: "dt", children: "Kogito URL: " }), _jsx(TextListItem, { component: "dd", children: _jsx("a", { href: "https://kogito.kie.org", target: "_blank", rel: "noreferrer", children: "https://kogito.kie.org" }) }), _jsx(TextListItem, { component: "dt", children: "Data-Index URL: " }), _jsxs(TextListItem, { component: "dd", children: [dataIndexURL, " "] })] })] }) }));
};
export default AboutModalBox;
//# sourceMappingURL=AboutModalBox.js.map