import BpmnEditor from "./bpmn/BpmnEditor";
import { By } from "selenium-webdriver";
import DmnEditor from "./dmn/DmnEditor";
import Page from "../Page";
import SwfEditor from "./swf/SwfEditor";
class EditorPage extends Page {
    async getEditor() {
        const frameLocator = this.tools.by(EditorPage.FRAME_LOCATOR);
        await frameLocator.wait(2000).untilPresent();
        const frame = await frameLocator.getElement();
        await frame.scroll();
        return frame;
    }
    async getDmnEditor() {
        const editor = await this.getEditor();
        return await this.tools.createPageFragment(DmnEditor, editor);
    }
    async getBpmnEditor() {
        const editor = await this.getEditor();
        return await this.tools.createPageFragment(BpmnEditor, editor);
    }
    async getSwfEditor() {
        const editor = await this.getEditor();
        return await this.tools.createPageFragment(SwfEditor, editor);
    }
}
EditorPage.FRAME_LOCATOR = By.xpath("//iframe[contains(@class,'kogito-iframe') or contains(@id,'kogito-iframe')]");
export default EditorPage;
//# sourceMappingURL=EditorPage.js.map