import { EditorFactory, EditorInitArgs, KogitoEditorChannelApi, KogitoEditorEnvelopeApi, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { EditorContextExposedInteropApi, I18nExposedInteropApi, KeyboardShortcutsExposedInteropApi, NotificationsExposedInteropApi, ResourceContentExposedInteropApi, StateControlExposedInteropApi, WorkspaceExposedInteropApi } from "./exposedInteropApi";
import { TextFormatter } from "./TextFormatter";
import { GwtAppFormerConsumedInteropApi } from "./consumedInteropApi/GwtAppFormerConsumedInteropApi";
import { GwtEditorWrapper } from "./GwtEditorWrapper";
import { GwtLanguageData } from "./GwtLanguageData";
import { GwtStateControlService } from "./gwtStateControl";
export interface CustomWindow extends Window {
    startStandaloneEditor?: () => void;
    gwt: {
        stateControlService: StateControlExposedInteropApi;
    };
    envelope: {
        editorContext: EditorContextExposedInteropApi;
        resourceContentEditorService?: ResourceContentExposedInteropApi;
        keyboardShortcutsService: KeyboardShortcutsExposedInteropApi;
        workspaceService: WorkspaceExposedInteropApi;
        i18nService: I18nExposedInteropApi;
        notificationsService: NotificationsExposedInteropApi;
    };
}
export declare class GwtEditorWrapperFactory<E extends GwtEditorWrapper> implements EditorFactory<E, KogitoEditorEnvelopeApi, KogitoEditorChannelApi> {
    private readonly languageData;
    private readonly gwtEditorDelegate;
    readonly gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    };
    readonly textFormatter: TextFormatter;
    readonly gwtAppFormerConsumedInteropApi: GwtAppFormerConsumedInteropApi;
    readonly gwtStateControlService: GwtStateControlService;
    readonly kieBcEditorsI18n: I18n<import("./i18n").KieBcEditorsI18n>;
    constructor(languageData: GwtLanguageData, gwtEditorDelegate: (factory: GwtEditorWrapperFactory<E>, initArgs: EditorInitArgs) => E, gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    }, textFormatter?: TextFormatter, gwtAppFormerConsumedInteropApi?: GwtAppFormerConsumedInteropApi, gwtStateControlService?: GwtStateControlService, kieBcEditorsI18n?: I18n<import("./i18n").KieBcEditorsI18n>);
    gwtEditor: E;
    createEditor(envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, KogitoEditorChannelApi>, initArgs: EditorInitArgs): Promise<E>;
    private exposeEnvelopeContext;
    private appendGwtLocaleMetaTag;
    private loadResource;
    private recursivelyLoadScriptsStartingFrom;
}
//# sourceMappingURL=GwtEditorWrapperFactory.d.ts.map