import { Job, JobStatus, BulkCancel, JobOperationResult, JobsSortBy, JobsManagementState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { JobsManagementQueries } from "./JobsManagementQueries";
export interface JobsManagementGatewayApi {
    jobsManagementState: any;
    initialLoad: (filter: JobStatus[], orderBy: JobsSortBy) => Promise<void>;
    applyFilter: (filter: JobStatus[]) => Promise<void>;
    bulkCancel: (jobsToBeActioned: Job[]) => Promise<BulkCancel>;
    cancelJob: (job: Pick<Job, "id" | "endpoint">) => Promise<JobOperationResult>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    sortBy: (orderBy: JobsSortBy) => Promise<void>;
    query(offset: number, limit: number): Promise<Job[]>;
    onUpdateJobsManagementState: (listener: OnUpdateJobsManagementStateListener) => UnSubscribeHandler;
}
export interface OnUpdateJobsManagementStateListener {
    onUpdate: (jobsManagementState: JobsManagementState) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class JobsManagementGatewayApiImpl implements JobsManagementGatewayApi {
    private readonly queries;
    private readonly onUpdateJobsManagementStateListeners;
    private _JobsManagementState;
    constructor(queries: JobsManagementQueries);
    get jobsManagementState(): JobsManagementState;
    initialLoad: (filter: JobStatus[], orderBy: JobsSortBy) => Promise<any>;
    applyFilter: (filter: JobStatus[]) => Promise<void>;
    cancelJob: (job: Pick<Job, "id" | "endpoint">) => Promise<JobOperationResult>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    bulkCancel: (jobsToBeActioned: (Job & {
        errorMessage?: string;
    })[]) => Promise<BulkCancel>;
    sortBy: (orderBy: JobsSortBy) => Promise<void>;
    onUpdateJobsManagementState(listener: OnUpdateJobsManagementStateListener): UnSubscribeHandler;
    query(offset: number, limit: number): Promise<Job[]>;
}
//# sourceMappingURL=JobsManagementGatewayApi.d.ts.map