import { handleProcessAbort, handleProcessSkip, handleProcessRetry, jobCancel, handleJobReschedule, handleNodeTrigger, handleProcessVariableUpdate, handleNodeInstanceCancel, handleNodeInstanceRetrigger, getProcessDetails, getJobs, getSVG, getTriggerableNodes, } from "@kie-tools/runtime-tools-process-gateway-api/dist/gatewayApi";
export class GraphQLProcessDetailsQueries {
    constructor(client, options) {
        this.client = client;
        this.options = options;
    }
    async getProcessDetails(id) {
        return getProcessDetails(id, this.client).then((details) => {
            var _a, _b, _c, _d, _e, _f;
            return {
                ...details,
                endpoint: (_c = (_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.transformEndpointBaseUrl) === null || _b === void 0 ? void 0 : _b.call(_a, details.endpoint)) !== null && _c !== void 0 ? _c : details.endpoint,
                serviceUrl: (_f = (_e = (_d = this.options) === null || _d === void 0 ? void 0 : _d.transformEndpointBaseUrl) === null || _e === void 0 ? void 0 : _e.call(_d, details.serviceUrl)) !== null && _f !== void 0 ? _f : details.serviceUrl,
            };
        });
    }
    async getJobs(id) {
        return Promise.resolve(getJobs(id, this.client));
    }
    async handleProcessSkip(processInstance) {
        return handleProcessSkip(processInstance, this.client);
    }
    async handleProcessAbort(processInstance) {
        return handleProcessAbort(processInstance, this.client);
    }
    async handleProcessRetry(processInstance) {
        return handleProcessRetry(processInstance, this.client);
    }
    async getSVG(processInstance) {
        return Promise.resolve(getSVG(processInstance, this.client));
    }
    async jobCancel(job) {
        return jobCancel(job, this.client);
    }
    async rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
    }
    async getTriggerableNodes(processInstance) {
        return Promise.resolve(getTriggerableNodes(processInstance, this.client));
    }
    async handleNodeTrigger(processInstance, node) {
        return handleNodeTrigger(processInstance, node, this.client);
    }
    async handleNodeInstanceCancel(processInstance, node) {
        return handleNodeInstanceCancel(processInstance, node, this.client);
    }
    async handleProcessVariableUpdate(processInstance, updateJson) {
        return handleProcessVariableUpdate(processInstance, updateJson, this.client);
    }
    async handleNodeInstanceRetrigger(processInstance, node) {
        return handleNodeInstanceRetrigger(processInstance, node, this.client);
    }
}
//# sourceMappingURL=ProcessDetailsQueries.js.map