import { MessageType } from "../message";
import { MessageProperty } from "../message/MessageProperty";
export class DashbuilderComponentDispatcher {
    constructor(bus, componentController) {
        this.bus = bus;
        this.componentController = componentController;
        this.messageDispatcher = (message) => {
            if (message.type === MessageType.INIT) {
                this.componentId = message.properties.get(MessageProperty.COMPONENT_ID);
                this.componentController.init(message.properties);
            }
            if (message.type === MessageType.DATASET) {
                const dataSet = message.properties.get(MessageProperty.DATASET);
                this.componentController.onDataSet(dataSet, message.properties);
            }
            if (message.type === MessageType.FUNCTION_RESPONSE) {
                const functionResponse = message.properties.get(MessageProperty.FUNCTION_RESPONSE);
                this.componentController.receiveFunctionResponse(functionResponse);
            }
        };
    }
    isAutoReady() {
        return true;
    }
    init() {
        this.bus.setListener(this.messageDispatcher);
        this.bus.start();
    }
    sendMessage(componentMessage) {
        componentMessage.properties.set(MessageProperty.COMPONENT_ID, this.componentId);
        window.parent.postMessage(componentMessage, window.location.href);
    }
    stop() {
        this.bus.destroy();
    }
}
//# sourceMappingURL=DashbuilderComponentDispatcher.js.map