import * as React from "react";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { Position } from "monaco-editor";
interface Props {
    onReady: () => void;
    onStateControlCommandUpdate: (command: StateControlCommand) => void;
    onNewEdit: (edit: WorkspaceEdit) => void;
    setNotifications: (normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]) => void;
    channelType: ChannelType;
}
export type DashbuilderEditorRef = {
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    moveCursorToPosition(position: Position): void;
};
export declare const DashbuilderEditor: React.ForwardRefExoticComponent<Props & React.RefAttributes<DashbuilderEditorRef | undefined>>;
export {};
//# sourceMappingURL=DashbuilderEditor.d.ts.map