/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluentImpl;
import java.util.Objects;

public class CronJobSpecBuilder
extends CronJobSpecFluentImpl<CronJobSpecBuilder>
implements VisitableBuilder<CronJobSpec, CronJobSpecBuilder> {
    CronJobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobSpecBuilder() {
        this(true);
    }

    public CronJobSpecBuilder(Boolean validationEnabled) {
        this(new CronJobSpec(), validationEnabled);
    }

    public CronJobSpecBuilder(CronJobSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CronJobSpecBuilder(CronJobSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CronJobSpec(), validationEnabled);
    }

    public CronJobSpecBuilder(CronJobSpecFluent<?> fluent, CronJobSpec instance) {
        this(fluent, instance, true);
    }

    public CronJobSpecBuilder(CronJobSpecFluent<?> fluent, CronJobSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConcurrencyPolicy(instance.getConcurrencyPolicy());
        fluent.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
        fluent.withJobTemplate(instance.getJobTemplate());
        fluent.withSchedule(instance.getSchedule());
        fluent.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
        fluent.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
        fluent.withSuspend(instance.getSuspend());
        this.validationEnabled = validationEnabled;
    }

    public CronJobSpecBuilder(CronJobSpec instance) {
        this(instance, (Boolean)true);
    }

    public CronJobSpecBuilder(CronJobSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
        this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
        this.withJobTemplate(instance.getJobTemplate());
        this.withSchedule(instance.getSchedule());
        this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
        this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
        this.withSuspend(instance.getSuspend());
        this.validationEnabled = validationEnabled;
    }

    public CronJobSpec build() {
        CronJobSpec buildable = new CronJobSpec(this.fluent.getConcurrencyPolicy(), this.fluent.getFailedJobsHistoryLimit(), this.fluent.getJobTemplate(), this.fluent.getSchedule(), this.fluent.getStartingDeadlineSeconds(), this.fluent.getSuccessfulJobsHistoryLimit(), this.fluent.getSuspend());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobSpecBuilder that = (CronJobSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

