/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.io.ImmutableStorageCredential;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface StorageCredential
extends Serializable {
    public String prefix();

    public Map<String, String> config();

    default public void validate() {
        Preconditions.checkArgument((!this.prefix().isEmpty() ? 1 : 0) != 0, (Object)"Invalid prefix: must be non-empty");
        Preconditions.checkArgument((!this.config().isEmpty() ? 1 : 0) != 0, (Object)"Invalid config: must be non-empty");
    }

    public static StorageCredential create(String prefix, Map<String, String> config) {
        return ImmutableStorageCredential.builder().prefix(prefix).config(config).build();
    }
}

