/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedPageReader;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.IPageReader;

public class MemAlignedChunkReader
implements IChunkReader {
    private final MemPointIterator timeValuePairIterator;
    private final Filter globalTimeFilter;
    private final List<IPageReader> pageReaderList;

    public MemAlignedChunkReader(AlignedReadOnlyMemChunk readableChunk, Filter globalTimeFilter) {
        this.timeValuePairIterator = readableChunk.getMemPointIterator();
        this.globalTimeFilter = globalTimeFilter;
        this.pageReaderList = new ArrayList<IPageReader>();
        this.initAllPageReaders(readableChunk.getDataTypes(), readableChunk.getTimeStatisticsList(), readableChunk.getValuesStatisticsList());
    }

    private void initAllPageReaders(List<TSDataType> tsDataTypes, List<Statistics<? extends Serializable>> timeStatistics, List<Statistics<? extends Serializable>[]> valuesStatistics) {
        TsBlockSupplier tsBlockSupplier = new TsBlockSupplier();
        for (int pageIndex = 0; pageIndex < timeStatistics.size(); ++pageIndex) {
            MemAlignedPageReader pageReader = new MemAlignedPageReader(tsBlockSupplier, pageIndex, tsDataTypes, timeStatistics.get(pageIndex), valuesStatistics.get(pageIndex), this.globalTimeFilter);
            this.pageReaderList.add(pageReader);
        }
    }

    public boolean hasNextSatisfiedPage() throws IOException {
        throw new IOException("mem chunk reader does not support this method");
    }

    public BatchData nextPageData() throws IOException {
        throw new IOException("mem chunk reader does not support this method");
    }

    public void close() {
    }

    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }

    class TsBlockSupplier
    implements Supplier<TsBlock> {
        private int tsBlockIndex;

        public void setTsBlockIndex(int tsBlockIndex) {
            this.tsBlockIndex = tsBlockIndex;
        }

        @Override
        public TsBlock get() {
            return MemAlignedChunkReader.this.timeValuePairIterator.getBatch(this.tsBlockIndex);
        }
    }
}

